/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.Session;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionModule;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueViewModule;
import org.apache.james.queue.rabbitmq.view.cassandra.EnqueuedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;
import org.apache.james.queue.rabbitmq.view.cassandra.model.EnqueuedItemWithSlicingContext;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class EnqueuedMailsDaoTest {
    private static final MailQueueName OUT_GOING_1 = MailQueueName.fromString((String)"OUT_GOING_1");
    private static final EnqueueId ENQUEUE_ID = EnqueueId.ofSerialized((String)"110e8400-e29b-11d4-a716-446655440000");
    private static final String NAME = "name";
    private static int BUCKET_ID_VALUE = 10;
    private static final BucketedSlices.BucketId BUCKET_ID = BucketedSlices.BucketId.of((int)BUCKET_ID_VALUE);
    private static final Instant NOW = Instant.now();
    private static final BucketedSlices.Slice SLICE_OF_NOW = BucketedSlices.Slice.of((Instant)NOW);
    private static final BlobId.Factory BLOB_ID_FACTORY = new HashBlobId.Factory();
    private static final BlobId HEADER_BLOB_ID = BLOB_ID_FACTORY.from("header blob id");
    private static final BlobId BODY_BLOB_ID = BLOB_ID_FACTORY.from("body blob id");
    private static final MimeMessagePartsId MIME_MESSAGE_PARTS_ID = MimeMessagePartsId.builder().headerBlobId(HEADER_BLOB_ID).bodyBlobId(BODY_BLOB_ID).build();
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraModule.aggregateModules((CassandraModule[])new CassandraModule[]{CassandraSchemaVersionModule.MODULE, CassandraMailQueueViewModule.MODULE}));
    private EnqueuedMailsDAO testee;

    EnqueuedMailsDaoTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        HashBlobId.Factory blobFactory = new HashBlobId.Factory();
        this.testee = new EnqueuedMailsDAO((Session)cassandra.getConf(), (BlobId.Factory)blobFactory);
    }

    @Test
    void insertShouldWork() throws Exception {
        this.testee.insert(EnqueuedItemWithSlicingContext.builder().enqueuedItem(EnqueuedItem.builder().enqueueId(ENQUEUE_ID).mailQueueName(OUT_GOING_1).mail((Mail)FakeMail.builder().name(NAME).build()).enqueuedTime(NOW).mimeMessagePartsId(MIME_MESSAGE_PARTS_ID).build()).slicingContext(EnqueuedItemWithSlicingContext.SlicingContext.of((BucketedSlices.BucketId)BucketedSlices.BucketId.of((int)BUCKET_ID_VALUE), (Instant)NOW)).build()).block();
        List selectedEnqueuedMails = (List)this.testee.selectEnqueuedMails(OUT_GOING_1, SLICE_OF_NOW, BUCKET_ID).collectList().block();
        Assertions.assertThat((List)selectedEnqueuedMails).hasSize(1);
    }

    @Test
    void selectEnqueuedMailsShouldWork() throws Exception {
        this.testee.insert(EnqueuedItemWithSlicingContext.builder().enqueuedItem(EnqueuedItem.builder().enqueueId(ENQUEUE_ID).mailQueueName(OUT_GOING_1).mail((Mail)FakeMail.builder().name(NAME).build()).enqueuedTime(NOW).mimeMessagePartsId(MIME_MESSAGE_PARTS_ID).build()).slicingContext(EnqueuedItemWithSlicingContext.SlicingContext.of((BucketedSlices.BucketId)BucketedSlices.BucketId.of((int)BUCKET_ID_VALUE), (Instant)NOW)).build()).block();
        this.testee.insert(EnqueuedItemWithSlicingContext.builder().enqueuedItem(EnqueuedItem.builder().enqueueId(ENQUEUE_ID).mailQueueName(OUT_GOING_1).mail((Mail)FakeMail.builder().name(NAME).build()).enqueuedTime(NOW).mimeMessagePartsId(MIME_MESSAGE_PARTS_ID).build()).slicingContext(EnqueuedItemWithSlicingContext.SlicingContext.of((BucketedSlices.BucketId)BucketedSlices.BucketId.of((int)(BUCKET_ID_VALUE + 1)), (Instant)NOW)).build()).block();
        List selectedEnqueuedMails = (List)this.testee.selectEnqueuedMails(OUT_GOING_1, SLICE_OF_NOW, BUCKET_ID).collectList().block();
        ((ListAssert)Assertions.assertThat((List)selectedEnqueuedMails).hasSize(1)).hasOnlyOneElementSatisfying(selectedEnqueuedMail -> {
            EnqueuedItem enqueuedItem = selectedEnqueuedMail.getEnqueuedItem();
            EnqueuedItemWithSlicingContext.SlicingContext slicingContext = selectedEnqueuedMail.getSlicingContext();
            SoftAssertions.assertSoftly(softly -> {
                softly.assertThat((Object)slicingContext.getBucketId()).isEqualTo((Object)BUCKET_ID);
                softly.assertThat(slicingContext.getTimeRangeStart()).isEqualTo((Object)NOW.truncatedTo(ChronoUnit.MILLIS));
                softly.assertThat((Object)enqueuedItem.getMailQueueName()).isEqualTo((Object)OUT_GOING_1);
                softly.assertThat(enqueuedItem.getEnqueuedTime()).isEqualTo((Object)NOW.truncatedTo(ChronoUnit.MILLIS));
                softly.assertThat((Object)enqueuedItem.getEnqueueId()).isEqualTo((Object)ENQUEUE_ID);
                softly.assertThat(enqueuedItem.getMail().getName()).isEqualTo(NAME);
                softly.assertThat((Object)enqueuedItem.getPartsId()).isEqualTo((Object)MIME_MESSAGE_PARTS_ID);
            });
        });
    }
}

