/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.james.queue.rabbitmq.view.cassandra.EnqueuedMailsDaoUtil;
import org.apache.mailet.Attribute;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnqueuedMailsDaoUtilTest {
    EnqueuedMailsDaoUtilTest() {
    }

    @Test
    void toAttributesShouldReturnEmptyWhenEmptyRawAttributeMap() {
        ImmutableMap attrMap = ImmutableMap.of();
        Assertions.assertThat((List)EnqueuedMailsDaoUtil.toAttributes((Map)attrMap)).isEmpty();
    }

    @Test
    void toAttributesShouldConvertRawAttributeMap() {
        ImmutableMap attrMap = ImmutableMap.of((Object)"Header-1", (Object)this.toByteBuffer("{\"serializer\":\"StringSerializer\",\"value\":\"alice\"}"));
        Assertions.assertThat((List)EnqueuedMailsDaoUtil.toAttributes((Map)attrMap)).containsExactly((Object[])new Attribute[]{Attribute.convertToAttribute((String)"Header-1", (Object)"alice")});
    }

    private ByteBuffer toByteBuffer(String value) {
        return ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8));
    }
}

