/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import java.time.Duration;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class CassandraMailQueueViewConfigurationTest {
    CassandraMailQueueViewConfigurationTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(CassandraMailQueueViewConfiguration.class).verify();
    }

    @Test
    void validateConfigurationChangeShouldAcceptIdentity() {
        CassandraMailQueueViewConfiguration configuration = CassandraMailQueueViewConfiguration.builder().bucketCount(2).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build();
        Assertions.assertThatCode(() -> configuration.validateConfigurationChange(configuration)).doesNotThrowAnyException();
    }

    @Test
    void validateConfigurationChangeShouldAcceptBucketCountIncrease() {
        CassandraMailQueueViewConfiguration configuration = CassandraMailQueueViewConfiguration.builder().bucketCount(2).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build();
        Assertions.assertThatCode(() -> configuration.validateConfigurationChange(CassandraMailQueueViewConfiguration.builder().bucketCount(3).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build())).doesNotThrowAnyException();
    }

    @Test
    void validateConfigurationChangeShouldAcceptDividingSliceWindow() {
        CassandraMailQueueViewConfiguration configuration = CassandraMailQueueViewConfiguration.builder().bucketCount(2).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build();
        Assertions.assertThatCode(() -> configuration.validateConfigurationChange(CassandraMailQueueViewConfiguration.builder().bucketCount(2).updateBrowseStartPace(1000).sliceWindow(Duration.ofMinutes(20L)).build())).doesNotThrowAnyException();
    }

    @Test
    void validateConfigurationChangeShouldRejectArbitraryDecreaseSliceWindow() {
        CassandraMailQueueViewConfiguration configuration = CassandraMailQueueViewConfiguration.builder().bucketCount(2).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build();
        Assertions.assertThatThrownBy(() -> configuration.validateConfigurationChange(CassandraMailQueueViewConfiguration.builder().bucketCount(2).updateBrowseStartPace(1000).sliceWindow(Duration.ofMinutes(25L)).build())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void validateConfigurationChangeShouldRejectDecreaseBucketCount() {
        CassandraMailQueueViewConfiguration configuration = CassandraMailQueueViewConfiguration.builder().bucketCount(2).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build();
        Assertions.assertThatThrownBy(() -> configuration.validateConfigurationChange(CassandraMailQueueViewConfiguration.builder().bucketCount(1).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build())).isInstanceOf(IllegalArgumentException.class);
    }

    @Nested
    class FromConfiguration {
        FromConfiguration() {
        }

        @Test
        void fromShouldReturnDefaultForEmptyConfiguration() {
            CassandraMailQueueViewConfiguration actual = CassandraMailQueueViewConfiguration.from((Configuration)new PropertiesConfiguration());
            Assertions.assertThat((Object)actual).isEqualTo((Object)CassandraMailQueueViewConfiguration.DEFAULT);
        }

        @Test
        void fromShouldReturnConfiguredBucketCount() {
            PropertiesConfiguration configuration = new PropertiesConfiguration();
            configuration.addProperty("mailqueue.view.bucketCount", (Object)"8");
            CassandraMailQueueViewConfiguration actual = CassandraMailQueueViewConfiguration.from((Configuration)configuration);
            Assertions.assertThat((int)actual.getBucketCount()).isEqualTo(8);
        }

        @Test
        void fromShouldReturnConfiguredUpdateBrowseStartPace() {
            PropertiesConfiguration configuration = new PropertiesConfiguration();
            configuration.addProperty("mailqueue.view.updateBrowseStartPace", (Object)"100");
            CassandraMailQueueViewConfiguration actual = CassandraMailQueueViewConfiguration.from((Configuration)configuration);
            Assertions.assertThat((int)actual.getUpdateBrowseStartPace()).isEqualTo(100);
        }

        @Test
        void fromShouldReturnConfiguredSliceWindow() {
            PropertiesConfiguration configuration = new PropertiesConfiguration();
            configuration.addProperty("mailqueue.view.sliceWindow", (Object)"20min");
            CassandraMailQueueViewConfiguration actual = CassandraMailQueueViewConfiguration.from((Configuration)configuration);
            Assertions.assertThat((Duration)actual.getSliceWindow()).isEqualTo((Object)Duration.ofMinutes(20L));
        }
    }
}

