/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import java.time.Duration;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.ConfigurationChanged;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.ConfigurationChangedDTO;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class ConfigurationChangedDTOTest {
    private static final int EVENT_ID_SERIALIZED = 10;
    private static final EventId EVENT_ID = EventId.fromSerialized((int)10);
    private static final Duration ONE_HOUR = Duration.ofHours(1L);
    private static final int BUCKET_COUNT = 2;
    private static final int UPDATE_PACE = 3;
    private static final String CONFIGURATION_AGGREGATE_KEY = "aggrKey";

    ConfigurationChangedDTOTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(ConfigurationChangedDTO.class).verify();
    }

    @Test
    void fromShouldThrowWhenConfigurationAddedIsNull() {
        Assertions.assertThatThrownBy(() -> ConfigurationChangedDTO.from(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromShouldReturnCorrespondingDTO() {
        ConfigurationChanged configurationChanged = new ConfigurationChanged(() -> CONFIGURATION_AGGREGATE_KEY, EVENT_ID, CassandraMailQueueViewConfiguration.builder().bucketCount(2).updateBrowseStartPace(3).sliceWindow(ONE_HOUR).build());
        ConfigurationChangedDTO dto = ConfigurationChangedDTO.from((ConfigurationChanged)configurationChanged);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(dto.getEventId()).isEqualTo(10);
            softly.assertThat(dto.getType()).isEqualTo("cassandra-mail-queue-view-configuration");
            softly.assertThat(dto.getBucketCount()).isEqualTo(2);
            softly.assertThat(dto.getUpdateBrowseStartPace()).isEqualTo(3);
            softly.assertThat(dto.getSliceWindow()).isEqualTo((Object)ONE_HOUR);
        });
    }

    @Test
    void toEventShouldReturnCorrespondingConfigurationChangedEvent() {
        ConfigurationChangedDTO dto = new ConfigurationChangedDTO(10, CONFIGURATION_AGGREGATE_KEY, "cassandra-mail-queue-view-configuration", 2, 3, ONE_HOUR);
        ConfigurationChanged event = dto.toEvent();
        CassandraMailQueueViewConfiguration mailQueueViewConfiguration = event.getConfiguration();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)event.eventId()).isEqualTo((Object)EVENT_ID);
            softly.assertThat(event.getAggregateId().asAggregateKey()).isEqualTo(CONFIGURATION_AGGREGATE_KEY);
            softly.assertThat(mailQueueViewConfiguration.getBucketCount()).isEqualTo(2);
            softly.assertThat(mailQueueViewConfiguration.getUpdateBrowseStartPace()).isEqualTo(3);
            softly.assertThat(mailQueueViewConfiguration.getSliceWindow()).isEqualTo((Object)ONE_HOUR);
        });
    }
}

