/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.Duration;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.ConfigurationChangedDTO;
import org.apache.james.util.ClassLoaderUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DTOTest {
    private static final int EVENT_ID = 0;
    private static final int BUCKET_COUNT = 1;
    private static final int UPDATE_PACE = 1000;
    private static final Duration SLICE_WINDOW = Duration.ofHours(1L);
    private static final String CONFIGURATION_AGGREGATE_KEY = "aggKey";
    private static final ConfigurationChangedDTO CONFIGURATION_CHANGED_DTO = new ConfigurationChangedDTO(0, "aggKey", "cassandra-mail-queue-view-configuration", 1, 1000, SLICE_WINDOW);
    private static final String CONFIGURATION_CHANGED_DTO_JSON = ClassLoaderUtils.getSystemResourceAsString((String)"json/mailqueueview/configuration/configuration_changed.json");
    private ObjectMapper objectMapper;

    DTOTest() {
    }

    @BeforeEach
    void setUp() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        this.objectMapper.registerSubtypes(new NamedType[]{new NamedType(ConfigurationChangedDTO.class, "cassandra-mail-queue-view-configuration")});
    }

    @Test
    void shouldSerializeConfigurationChangedDTO() throws Exception {
        JsonAssertions.assertThatJson((Object)this.objectMapper.writeValueAsString((Object)CONFIGURATION_CHANGED_DTO)).isEqualTo((Object)CONFIGURATION_CHANGED_DTO_JSON);
    }

    @Test
    void shouldDeserializeConfigurationChangedDTO() throws Exception {
        Assertions.assertThat((Object)((ConfigurationChangedDTO)this.objectMapper.readValue(CONFIGURATION_CHANGED_DTO_JSON, ConfigurationChangedDTO.class))).isEqualTo((Object)CONFIGURATION_CHANGED_DTO);
    }
}

