/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.cassandra.CassandraEventStoreExtension;
import org.apache.james.eventsourcing.eventstore.cassandra.JsonEventSerializer;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTOModule;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfigurationModule;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.EventsourcingConfigurationManagement;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class EventsourcingConfigurationManagementTest {
    @RegisterExtension
    static CassandraEventStoreExtension eventStoreExtension = new CassandraEventStoreExtension(JsonEventSerializer.forModules((EventDTOModule[])new EventDTOModule[]{CassandraMailQueueViewConfigurationModule.MAIL_QUEUE_VIEW_CONFIGURATION}).withoutNestedType());
    private static final int DEFAULT_BUCKET_COUNT = 10;
    private static final int DEFAULT_UPDATE_PACE = 100;
    private static final Duration ONE_HOUR = Duration.ofHours(1L);
    private static final Duration TWO_HOURS = Duration.ofHours(2L);
    private static final Duration FORTY_FIVE_MINUTES = Duration.ofMinutes(45L);
    private static final Duration THIRTY_MINUTES = Duration.ofMinutes(30L);
    private static final CassandraMailQueueViewConfiguration FIRST_CONFIGURATION = CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build();
    private static final CassandraMailQueueViewConfiguration SECOND_CONFIGURATION = CassandraMailQueueViewConfiguration.builder().bucketCount(11).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build();
    private static final CassandraMailQueueViewConfiguration THIRD_CONFIGURATION = CassandraMailQueueViewConfiguration.builder().bucketCount(12).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build();

    EventsourcingConfigurationManagementTest() {
    }

    private EventsourcingConfigurationManagement createConfigurationManagement(EventStore eventStore) {
        return new EventsourcingConfigurationManagement(eventStore);
    }

    @Test
    void loadShouldReturnEmptyIfNoConfigurationStored(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        Assertions.assertThat((Optional)Mono.from((Publisher)testee.load()).blockOptional()).isEmpty();
    }

    @Test
    void loadShouldReturnTheLastConfiguration(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(FIRST_CONFIGURATION);
        testee.registerConfiguration(SECOND_CONFIGURATION);
        testee.registerConfiguration(THIRD_CONFIGURATION);
        Assertions.assertThat((Optional)Mono.from((Publisher)testee.load()).blockOptional()).contains((Object)THIRD_CONFIGURATION);
    }

    @Test
    void loadConfigurationShouldThrowWhenConfigurationIsNull(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        Assertions.assertThatThrownBy(() -> testee.registerConfiguration(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void loadConfigurationShouldThrowWhenBucketCountDecrease(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build());
        Assertions.assertThatThrownBy(() -> testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(9).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void loadConfigurationShouldUpdateStoredConfigurationWhenIncreaseBucketCount(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build());
        CassandraMailQueueViewConfiguration increaseOneBucketConfiguration = CassandraMailQueueViewConfiguration.builder().bucketCount(11).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build();
        testee.registerConfiguration(increaseOneBucketConfiguration);
        Assertions.assertThat((Optional)Mono.from((Publisher)testee.load()).blockOptional()).contains((Object)increaseOneBucketConfiguration);
    }

    @Test
    void loadConfigurationShouldStoreConfiguration(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(FIRST_CONFIGURATION);
        Assertions.assertThat((Optional)Mono.from((Publisher)testee.load()).blockOptional()).contains((Object)FIRST_CONFIGURATION);
    }

    @Test
    void loadConfigurationShouldThrowWhenIncreaseSliceWindow(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build());
        Assertions.assertThatThrownBy(() -> testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(TWO_HOURS).build())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void loadConfigurationShouldThrowWhenDecreaseSliceWindowByANotDivisibleNumber(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build());
        Assertions.assertThatThrownBy(() -> testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(FORTY_FIVE_MINUTES).build())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void loadConfigurationShouldUpdateConfigurationWhenDecreaseSliceWindowByADivisibleNumber(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build());
        CassandraMailQueueViewConfiguration decreaseTwiceSliceWindowConfiguration = CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(THIRTY_MINUTES).build();
        testee.registerConfiguration(decreaseTwiceSliceWindowConfiguration);
        Assertions.assertThat((Optional)Mono.from((Publisher)testee.load()).blockOptional()).contains((Object)decreaseTwiceSliceWindowConfiguration);
    }

    @Test
    void loadConfigurationShouldUpdateConfigurationWhenIncreaseUpdatePace(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build());
        CassandraMailQueueViewConfiguration decreaseTwiceSliceWindowConfiguration = CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(110).sliceWindow(ONE_HOUR).build();
        testee.registerConfiguration(decreaseTwiceSliceWindowConfiguration);
        Assertions.assertThat((Optional)Mono.from((Publisher)testee.load()).blockOptional()).contains((Object)decreaseTwiceSliceWindowConfiguration);
    }

    @Test
    void loadConfigurationShouldUpdateConfigurationWhenDecreaseUpdatePace(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(100).sliceWindow(ONE_HOUR).build());
        CassandraMailQueueViewConfiguration decreaseTwiceSliceWindowConfiguration = CassandraMailQueueViewConfiguration.builder().bucketCount(10).updateBrowseStartPace(90).sliceWindow(ONE_HOUR).build();
        testee.registerConfiguration(decreaseTwiceSliceWindowConfiguration);
        Assertions.assertThat((Optional)Mono.from((Publisher)testee.load()).blockOptional()).contains((Object)decreaseTwiceSliceWindowConfiguration);
    }

    @Test
    void loadConfigurationShouldIgnoreDuplicateWhenStoreTheSameConfigurationTwice(EventStore eventStore) {
        EventsourcingConfigurationManagement testee = this.createConfigurationManagement(eventStore);
        testee.registerConfiguration(FIRST_CONFIGURATION);
        testee.registerConfiguration(FIRST_CONFIGURATION);
        Assertions.assertThat((List)((History)Mono.from((Publisher)eventStore.getEventsOfAggregate(EventsourcingConfigurationManagement.CONFIGURATION_AGGREGATE_ID)).block()).getEventsJava()).hasSize(1);
    }
}

