/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import java.time.Duration;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.RegisterConfigurationCommand;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RegisterConfigurationCommandTest {
    RegisterConfigurationCommandTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(RegisterConfigurationCommand.class).verify();
    }

    @Test
    void constructorShouldThrowWhenNullConfiguration() {
        Assertions.assertThatThrownBy(() -> new RegisterConfigurationCommand(null, () -> "agg")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void constructorShouldThrowWhenNullAggregateId() {
        CassandraMailQueueViewConfiguration configuration = CassandraMailQueueViewConfiguration.builder().bucketCount(2).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build();
        Assertions.assertThatThrownBy(() -> new RegisterConfigurationCommand(configuration, null)).isInstanceOf(NullPointerException.class);
    }
}

