/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.model;

import java.time.Duration;
import java.time.Instant;
import java.util.stream.Stream;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BucketedSlicesTest {
    private static final long ONE_HOUR_IN_SECONDS = 3600L;
    private static final Instant FIRST_SLICE_INSTANT = Instant.parse("2018-05-20T12:00:00.000Z");
    private static final Instant FIRST_SLICE_INSTANT_NEXT_HOUR = FIRST_SLICE_INSTANT.plusSeconds(3600L);
    private static final Instant FIRST_SLICE_INSTANT_NEXT_TWO_HOUR = FIRST_SLICE_INSTANT.plusSeconds(7200L);
    private static final Duration ONE_HOUR_SLICE_WINDOW = Duration.ofSeconds(3600L);
    private static final BucketedSlices.Slice FIRST_SLICE = BucketedSlices.Slice.of((Instant)FIRST_SLICE_INSTANT);
    private static final BucketedSlices.Slice FIRST_SLICE_NEXT_TWO_HOUR = BucketedSlices.Slice.of((Instant)FIRST_SLICE_INSTANT_NEXT_TWO_HOUR);

    BucketedSlicesTest() {
    }

    @Test
    void bucketIdShouldMatchBeanContract() {
        EqualsVerifier.forClass(BucketedSlices.BucketId.class).verify();
    }

    @Test
    void sliceShouldMatchBeanContract() {
        EqualsVerifier.forClass(BucketedSlices.Slice.class).verify();
    }

    @Test
    void bucketIdShouldThrowWhenValueIsNegative() {
        Assertions.assertThatThrownBy(() -> BucketedSlices.BucketId.of((int)-1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void allSlicesTillShouldReturnOnlyFirstSliceWhenEndAtInTheSameInterval() {
        Assertions.assertThat((Stream)FIRST_SLICE.allSlicesTill(FIRST_SLICE_INSTANT.plusSeconds(3599L), ONE_HOUR_SLICE_WINDOW)).containsOnly((Object[])new BucketedSlices.Slice[]{FIRST_SLICE});
    }

    @Test
    void allSlicesTillShouldReturnAllSlicesBetweenStartAndEndAt() {
        Stream allSlices = FIRST_SLICE.allSlicesTill(FIRST_SLICE_INSTANT_NEXT_TWO_HOUR.plusSeconds(3599L), ONE_HOUR_SLICE_WINDOW);
        Assertions.assertThat((Stream)allSlices).containsExactly((Object[])new BucketedSlices.Slice[]{FIRST_SLICE, BucketedSlices.Slice.of((Instant)FIRST_SLICE_INSTANT_NEXT_HOUR), BucketedSlices.Slice.of((Instant)FIRST_SLICE_INSTANT_NEXT_TWO_HOUR)});
    }

    @Test
    void allSlicesTillShouldReturnSameSlicesWhenEndAtsAreInTheSameInterval() {
        Stream allSlicesEndAtTheStartOfWindow = FIRST_SLICE.allSlicesTill(FIRST_SLICE_INSTANT_NEXT_TWO_HOUR, ONE_HOUR_SLICE_WINDOW);
        Stream allSlicesEndAtTheMiddleOfWindow = FIRST_SLICE.allSlicesTill(FIRST_SLICE_INSTANT_NEXT_TWO_HOUR.plusSeconds(1000L), ONE_HOUR_SLICE_WINDOW);
        Stream allSlicesEndAtTheEndWindow = FIRST_SLICE.allSlicesTill(FIRST_SLICE_INSTANT_NEXT_TWO_HOUR.plusSeconds(3599L), ONE_HOUR_SLICE_WINDOW);
        Object[] allSlicesInThreeHours = new BucketedSlices.Slice[]{FIRST_SLICE, BucketedSlices.Slice.of((Instant)FIRST_SLICE_INSTANT_NEXT_HOUR), BucketedSlices.Slice.of((Instant)FIRST_SLICE_INSTANT_NEXT_TWO_HOUR)};
        Assertions.assertThat((Stream)allSlicesEndAtTheStartOfWindow).containsExactly(allSlicesInThreeHours);
        Assertions.assertThat((Stream)allSlicesEndAtTheMiddleOfWindow).containsExactly(allSlicesInThreeHours);
        Assertions.assertThat((Stream)allSlicesEndAtTheEndWindow).containsExactly(allSlicesInThreeHours);
    }

    @Test
    void allSlicesTillShouldReturnEmptyIfEndAtBeforeStartSlice() {
        Stream allSlices = FIRST_SLICE_NEXT_TWO_HOUR.allSlicesTill(FIRST_SLICE_INSTANT, ONE_HOUR_SLICE_WINDOW);
        Assertions.assertThat((Stream)allSlices).isEmpty();
    }
}

