/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.model;

import java.util.UUID;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnqueueIdTest {
    private static final UUID UUID_1 = UUID.fromString("110e8400-e29b-11d4-a716-446655440000");

    EnqueueIdTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(EnqueueId.class).verify();
    }

    @Test
    void ofSerializedShouldDeserializeTheGivenEnqueueId() {
        Assertions.assertThat((Object)EnqueueId.ofSerialized((String)UUID_1.toString())).isEqualTo((Object)EnqueueId.of((UUID)UUID_1));
    }

    @Test
    void serializeShouldReturnAStringRepresentation() {
        EnqueueId enqueueId = EnqueueId.of((UUID)UUID_1);
        Assertions.assertThat((String)enqueueId.serialize()).isEqualTo(UUID_1.toString());
    }

    @Test
    void ofSerializedShouldRevertSerialize() {
        EnqueueId enqueueId = EnqueueId.of((UUID)UUID_1);
        Assertions.assertThat((Object)EnqueueId.ofSerialized((String)enqueueId.serialize())).isEqualTo((Object)enqueueId);
    }
}

