/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.model;

import java.time.Instant;
import javax.mail.MessagingException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;
import org.apache.james.queue.rabbitmq.view.cassandra.model.EnqueuedItemWithSlicingContext;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnqueuedItemWithSlicingContextTest {
    private EnqueuedItem enqueuedItem = EnqueuedItem.builder().enqueueId(EnqueueId.generate()).mailQueueName(MailQueueName.fromString((String)"mailQueueName")).mail((Mail)FakeMail.builder().name("name").build()).enqueuedTime(Instant.now()).mimeMessagePartsId(MimeMessagePartsId.builder().headerBlobId((BlobId)new HashBlobId.Factory().from("headerBlodId")).bodyBlobId((BlobId)new HashBlobId.Factory().from("bodyBlodId")).build()).build();
    private EnqueuedItemWithSlicingContext.SlicingContext slicingContext = EnqueuedItemWithSlicingContext.SlicingContext.of((BucketedSlices.BucketId)BucketedSlices.BucketId.of((int)1), (Instant)Instant.now());

    private EnqueuedItemWithSlicingContextTest() throws MessagingException {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(EnqueuedItemWithSlicingContext.class).verify();
    }

    @Test
    void slicingContextShouldMatchBeanContract() {
        EqualsVerifier.forClass(EnqueuedItemWithSlicingContext.SlicingContext.class).verify();
    }

    @Test
    void buildShouldThrowWhenEnqueuedItemIsNull() {
        EnqueuedItem enqueuedItem = null;
        Assertions.assertThatThrownBy(() -> EnqueuedItemWithSlicingContext.builder().enqueuedItem(enqueuedItem).slicingContext(this.slicingContext).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrowWhenSlicingContextIsNull() {
        EnqueuedItemWithSlicingContext.SlicingContext slicingContext = null;
        Assertions.assertThatThrownBy(() -> EnqueuedItemWithSlicingContext.builder().enqueuedItem(this.enqueuedItem).slicingContext(slicingContext).build()).isInstanceOf(NullPointerException.class);
    }
}

