/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.file;

import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.mailstore.api.MailStore;
import org.apache.james.repository.ObjectRepository;
import org.apache.james.user.api.User;
import org.apache.james.user.lib.AbstractJamesUsersRepository;
import org.apache.james.user.lib.DefaultJamesUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class UsersFileRepository
extends AbstractJamesUsersRepository {
    protected static boolean DEEP_DEBUG = false;
    private MailStore store;
    private ObjectRepository objectRepository;
    private static String urlSeparator = "/";
    private String destination;

    @Resource(name="mailstore")
    public void setStore(MailStore store) {
        this.store = store;
    }

    protected void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        this.destination = configuration.getString("destination.[@URL]");
        if (!this.destination.endsWith(urlSeparator)) {
            this.destination = this.destination + urlSeparator;
        }
    }

    @PostConstruct
    public void init() throws Exception {
        try {
            DefaultConfigurationBuilder objectConfiguration = new DefaultConfigurationBuilder();
            objectConfiguration.addProperty("[@destinationURL]", (Object)this.destination);
            objectConfiguration.addProperty("[@type]", (Object)"OBJECT");
            objectConfiguration.addProperty("[@model]", (Object)"SYNCHRONOUS");
            this.objectRepository = (ObjectRepository)this.store.select((HierarchicalConfiguration)objectConfiguration);
            if (this.getLogger().isDebugEnabled()) {
                StringBuffer logBuffer = new StringBuffer(192).append(((Object)((Object)this)).getClass().getName()).append(" created in ").append(this.destination);
                this.getLogger().debug((Object)logBuffer.toString());
            }
        }
        catch (Exception e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error((Object)("Failed to initialize repository:" + e.getMessage()), (Throwable)e);
            }
            throw e;
        }
    }

    public Iterator<String> list() {
        return this.objectRepository.list();
    }

    protected void doAddUser(User user) {
        try {
            this.objectRepository.put(user.getUserName(), (Object)user);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while storing user: " + e);
        }
    }

    public boolean addUser(String username, String password) {
        DefaultJamesUser newbie = new DefaultJamesUser(username, "SHA");
        newbie.setPassword(password);
        return this.addUser((User)newbie);
    }

    public synchronized User getUserByName(String name) {
        if (this.ignoreCase && (name = this.getRealName(name)) == null) {
            return null;
        }
        if (this.contains(name)) {
            try {
                return (User)this.objectRepository.get(name);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while retrieving user: " + e.getMessage());
            }
        }
        return null;
    }

    public User getUserByNameCaseInsensitive(String name) {
        String realName = this.getRealName(name, true);
        if (realName == null) {
            return null;
        }
        return this.getUserByName(realName);
    }

    public String getRealName(String name, boolean ignoreCase) {
        if (ignoreCase) {
            Iterator<String> it = this.list();
            while (it.hasNext()) {
                String temp = it.next();
                if (!name.equalsIgnoreCase(temp)) continue;
                return temp;
            }
            return null;
        }
        return this.objectRepository.containsKey(name) ? name : null;
    }

    public String getRealName(String name) {
        return this.getRealName(name, this.ignoreCase);
    }

    public void doUpdateUser(User user) {
        try {
            this.objectRepository.put(user.getUserName(), (Object)user);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while storing user: " + e);
        }
    }

    public synchronized void removeUser(String name) {
        this.objectRepository.remove(name);
    }

    public boolean contains(String name) {
        if (this.ignoreCase) {
            return this.containsCaseInsensitive(name);
        }
        return this.objectRepository.containsKey(name);
    }

    public boolean containsCaseInsensitive(String name) {
        Iterator<String> it = this.list();
        while (it.hasNext()) {
            if (!name.equalsIgnoreCase(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean test(String name, String password) {
        User user;
        try {
            user = this.getUserByName(name);
            if (user == null) {
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception retrieving User" + e);
        }
        return user.verifyPassword(password);
    }

    public int countUsers() {
        int count = 0;
        Iterator<String> it = this.list();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }
}

