/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vut.file;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.vut.lib.AbstractVirtualUserTable;
import org.apache.james.vut.lib.VirtualUserTableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLVirtualUserTable
extends AbstractVirtualUserTable {
    private Map<String, String> mappings;

    protected void doConfigure(HierarchicalConfiguration arg0) throws ConfigurationException {
        List mapConf = arg0.getList("mapping");
        this.mappings = new HashMap<String, String>();
        if (mapConf != null && mapConf.size() > 0) {
            for (int i = 0; i < mapConf.size(); ++i) {
                this.mappings.putAll(VirtualUserTableUtil.getXMLMappings((String)((String)mapConf.get(i))));
            }
        } else {
            throw new ConfigurationException("No mapping configured");
        }
    }

    protected boolean addMappingInternal(String user, String domain, String mapping) {
        return false;
    }

    protected String mapAddressInternal(String user, String domain) {
        if (this.mappings == null) {
            return null;
        }
        return VirtualUserTableUtil.getTargetString((String)user, (String)domain, this.mappings);
    }

    protected boolean removeMappingInternal(String user, String domain, String mapping) {
        return false;
    }

    protected Collection<String> getUserDomainMappingsInternal(String user, String domain) {
        if (this.mappings == null) {
            return null;
        }
        String maps = this.mappings.get(user + "@" + domain);
        if (maps != null) {
            return VirtualUserTableUtil.mappingToCollection((String)maps);
        }
        return null;
    }

    protected Map<String, Collection<String>> getAllMappingsInternal() {
        if (this.mappings != null && this.mappings.size() > 0) {
            HashMap<String, Collection<String>> mappingsNew = new HashMap<String, Collection<String>>();
            for (String key : this.mappings.keySet()) {
                mappingsNew.put(key, VirtualUserTableUtil.mappingToCollection((String)this.mappings.get(key).toString()));
            }
            return mappingsNew;
        }
        return null;
    }
}

