/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.ExecutionDetailsDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"Tasks"})
@Path(value=":task")
@Produces(value={"application/json"})
public class TasksRoutes
implements Routes {
    public static final String BASE = "/tasks";
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;

    @Inject
    public TasksRoutes(TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    @Override
    public String getBasePath() {
        return BASE;
    }

    @Override
    public void define(Service service) {
        service.get("/tasks/:id", this::getStatus, (ResponseTransformer)this.jsonTransformer);
        service.get("/tasks/:id/await", this::await, (ResponseTransformer)this.jsonTransformer);
        service.delete("/tasks/:id", this::cancel, (ResponseTransformer)this.jsonTransformer);
        service.get(BASE, this::list, (ResponseTransformer)this.jsonTransformer);
    }

    @GET
    @ApiOperation(value="Listing tasks")
    @ApiImplicitParams(value={@ApiImplicitParam(required=false, paramType="query parameter", dataType="String", defaultValue="None", example="?status=inProgress", value="If present, allow to filter the tasks and keep only the one with a given status. The status are one of [waiting, inProgress, failed, canceled, completed]")})
    @ApiResponses(value={@ApiResponse(code=200, message="A specific class execution details", response=List.class), @ApiResponse(code=400, message="The provided payload is invalid (JSON error or invalid status)"), @ApiResponse(code=404, message="The taskId is not found")})
    public Object list(Request req, Response response) {
        try {
            return ExecutionDetailsDto.from(Optional.ofNullable(req.queryParams("status")).map(TaskManager.Status::fromString).map(arg_0 -> ((TaskManager)this.taskManager).list(arg_0)).orElse(this.taskManager.list()));
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).cause(e).message("Invalid status query parameter").haltError();
        }
    }

    @GET
    @Path(value="/{taskId}")
    @ApiOperation(value="Getting a task execution details")
    @ApiResponses(value={@ApiResponse(code=200, message="A specific class execution details", response=ExecutionDetailsDto.class), @ApiResponse(code=400, message="The taskId is invalid"), @ApiResponse(code=404, message="The taskId is not found")})
    public Object getStatus(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        return this.respondStatus(taskId, () -> this.taskManager.getExecutionDetails(this.getTaskId(req)));
    }

    @GET
    @Path(value="/{taskId}/await")
    @ApiOperation(value="Await, then get a task execution details")
    @ApiResponses(value={@ApiResponse(code=200, message="A specific class execution details", response=ExecutionDetailsDto.class), @ApiResponse(code=400, message="The taskId is invalid"), @ApiResponse(code=404, message="The taskId is not found")})
    public Object await(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        return this.respondStatus(taskId, () -> this.taskManager.await(this.getTaskId(req)));
    }

    private Object respondStatus(TaskId taskId, Supplier<TaskExecutionDetails> executionDetailsSupplier) {
        try {
            TaskExecutionDetails executionDetails = executionDetailsSupplier.get();
            return ExecutionDetailsDto.from(executionDetails);
        }
        catch (TaskNotFoundException e) {
            throw ErrorResponder.builder().message(String.format("%s can not be found", taskId.getValue())).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError();
        }
    }

    @DELETE
    @Path(value="/{taskId}")
    @ApiOperation(value="Cancel a given task")
    @ApiResponses(value={@ApiResponse(code=204, message="Task is cancelled"), @ApiResponse(code=400, message="The taskId is invalid")})
    public Object cancel(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        this.taskManager.cancel(taskId);
        response.status(204);
        return "";
    }

    private TaskId getTaskId(Request req) {
        try {
            String id = req.params("id");
            return new TaskId(UUID.fromString(id));
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid task id").haltError();
        }
    }
}

