/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.HaltException;
import spark.Spark;

public class ErrorResponder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorResponder.class);
    private Integer statusCode;
    private ErrorType type;
    private String message;
    private Optional<Exception> cause = Optional.empty();

    public static ErrorResponder builder() {
        return new ErrorResponder();
    }

    public ErrorResponder statusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ErrorResponder type(ErrorType type) {
        this.type = type;
        return this;
    }

    public ErrorResponder message(String message) {
        this.message = message;
        return this;
    }

    public ErrorResponder cause(Exception cause) {
        this.cause = Optional.of(cause);
        return this;
    }

    public HaltException haltError() {
        Preconditions.checkNotNull((Object)this.statusCode, (Object)"statusCode must not be null in case of error");
        Preconditions.checkNotNull((Object)((Object)this.type), (Object)"type must not be null in case of error");
        Preconditions.checkNotNull((Object)this.message, (Object)"message must not be null in case of error");
        try {
            return Spark.halt((int)this.statusCode, (String)this.generateBody());
        }
        catch (JsonProcessingException e) {
            return Spark.halt((int)this.statusCode);
        }
    }

    public String asString() {
        try {
            return this.generateBody();
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed handling Error response formatting", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String generateBody() throws JsonProcessingException {
        return new JsonTransformer(new JsonTransformerModule[0]).render(new ErrorDetail(this.statusCode, this.type.getType(), this.message, this.cause.map(Throwable::getMessage)));
    }

    public static class ErrorDetail {
        private final int statusCode;
        private final String type;
        private final String message;
        private final Optional<String> details;

        @VisibleForTesting
        ErrorDetail(int statusCode, String type, String message, Optional<String> details) {
            this.statusCode = statusCode;
            this.type = type;
            this.message = message;
            this.details = details;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public Optional<String> getDetails() {
            return this.details;
        }

        public final boolean equals(Object o) {
            if (o instanceof ErrorDetail) {
                ErrorDetail that = (ErrorDetail)o;
                return Objects.equals(this.statusCode, that.statusCode) && Objects.equals(this.type, that.type) && Objects.equals(this.message, that.message) && Objects.equals(this.details, that.details);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.statusCode, this.type, this.message, this.details);
        }
    }

    public static enum ErrorType {
        INVALID_ARGUMENT("InvalidArgument"),
        NOT_FOUND("notFound"),
        WRONG_STATE("WrongState"),
        SERVER_ERROR("ServerError");

        private final String type;

        private ErrorType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

