/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.utils;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.james.webadmin.utils.JsonExtractException;

public class JsonExtractor<RequestT> {
    private final ObjectMapper objectMapper;
    private final Class<RequestT> type;

    public JsonExtractor(Class<RequestT> type, Module ... modules) {
        this(type, (List<Module>)ImmutableList.copyOf((Object[])modules));
    }

    public JsonExtractor(Class<RequestT> type, List<Module> modules) {
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new GuavaModule()).registerModules(modules);
        this.type = type;
    }

    public RequestT parse(String text) throws JsonExtractException {
        try {
            return (RequestT)this.objectMapper.readValue(text, this.type);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new JsonExtractException(e);
        }
    }
}

