/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.webadmin.PortSupplier;
import org.apache.james.webadmin.RandomPortSupplier;
import org.apache.james.webadmin.TlsConfiguration;

public class WebAdminConfiguration {
    public static final boolean DEFAULT_CORS_DISABLED = false;
    public static final String CORS_ALL_ORIGINS = "*";
    public static final String DEFAULT_HOST = "localhost";
    public static final WebAdminConfiguration DISABLED_CONFIGURATION = WebAdminConfiguration.builder().disabled().build();
    public static final WebAdminConfiguration TEST_CONFIGURATION = WebAdminConfiguration.builder().enabled().corsDisabled().host("127.0.0.1").port(new RandomPortSupplier()).build();
    private final boolean enabled;
    private final Optional<PortSupplier> port;
    private final Optional<TlsConfiguration> tlsConfiguration;
    private final boolean enableCORS;
    private final String urlCORSOrigin;
    private final String host;
    private final List<String> additionalRoutes;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    WebAdminConfiguration(boolean enabled, Optional<PortSupplier> port, Optional<TlsConfiguration> tlsConfiguration, boolean enableCORS, String urlCORSOrigin, String host, List<String> additionalRoutes) {
        this.enabled = enabled;
        this.port = port;
        this.tlsConfiguration = tlsConfiguration;
        this.enableCORS = enableCORS;
        this.urlCORSOrigin = urlCORSOrigin;
        this.host = host;
        this.additionalRoutes = additionalRoutes;
    }

    public List<String> getAdditionalRoutes() {
        return this.additionalRoutes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUrlCORSOrigin() {
        return this.urlCORSOrigin;
    }

    public PortSupplier getPort() {
        return this.port.orElseThrow(() -> new IllegalStateException("No port was specified"));
    }

    public TlsConfiguration getTlsConfiguration() {
        return this.tlsConfiguration.orElseThrow(() -> new IllegalStateException("No tls configuration"));
    }

    public boolean isEnableCORS() {
        return this.enableCORS;
    }

    public boolean isTlsEnabled() {
        return this.tlsConfiguration.isPresent();
    }

    public String getHost() {
        return this.host;
    }

    public final boolean equals(Object o) {
        if (o instanceof WebAdminConfiguration) {
            WebAdminConfiguration that = (WebAdminConfiguration)o;
            return Objects.equals(this.enabled, that.enabled) && Objects.equals(this.port, that.port) && Objects.equals(this.tlsConfiguration, that.tlsConfiguration) && Objects.equals(this.enableCORS, that.enableCORS) && Objects.equals(this.urlCORSOrigin, that.urlCORSOrigin) && Objects.equals(this.host, that.host) && Objects.equals(this.additionalRoutes, that.additionalRoutes);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.enabled, this.port, this.tlsConfiguration, this.enableCORS, this.urlCORSOrigin, this.host, this.additionalRoutes);
    }

    public static class Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<PortSupplier> port = Optional.empty();
        private Optional<Boolean> enableCORS = Optional.empty();
        private Optional<TlsConfiguration> tlsConfiguration = Optional.empty();
        private Optional<String> urlCORSOrigin = Optional.empty();
        private Optional<String> host = Optional.empty();
        private ImmutableList.Builder<String> additionalRoutes = ImmutableList.builder();

        public Builder tls(TlsConfiguration tlsConfiguration) {
            this.tlsConfiguration = Optional.of(tlsConfiguration);
            return this;
        }

        public Builder tls(Optional<TlsConfiguration> tlsConfiguration) {
            this.tlsConfiguration = tlsConfiguration;
            return this;
        }

        public Builder port(PortSupplier portSupplier) {
            this.port = Optional.of(portSupplier);
            return this;
        }

        public Builder enable(boolean isEnabled) {
            this.enabled = Optional.of(isEnabled);
            return this;
        }

        public Builder enabled() {
            return this.enable(true);
        }

        public Builder disabled() {
            return this.enable(false);
        }

        public Builder urlCORSOrigin(String origin) {
            this.urlCORSOrigin = Optional.ofNullable(origin);
            return this;
        }

        public Builder enableCORS(boolean isEnabled) {
            this.enableCORS = Optional.of(isEnabled);
            return this;
        }

        public Builder corsEnabled() {
            return this.enableCORS(true);
        }

        public Builder corsDisabled() {
            return this.enableCORS(false);
        }

        public Builder host(String host) {
            this.host = Optional.ofNullable(host);
            return this;
        }

        public Builder additionalRoute(String additionalRoute) {
            this.additionalRoutes.add((Object)additionalRoute);
            return this;
        }

        public Builder additionalRoutes(Collection<String> additionalRoutes) {
            this.additionalRoutes.addAll(additionalRoutes);
            return this;
        }

        public WebAdminConfiguration build() {
            Preconditions.checkState((boolean)this.enabled.isPresent(), (Object)"You need to explicitly enable or disable WebAdmin server");
            Preconditions.checkState((this.enabled.get() == false || this.port.isPresent() ? 1 : 0) != 0, (Object)"You need to specify a port for WebAdminConfiguration");
            return new WebAdminConfiguration(this.enabled.get(), this.port, this.tlsConfiguration, this.enableCORS.orElse(false), this.urlCORSOrigin.orElse(WebAdminConfiguration.CORS_ALL_ORIGINS), this.host.orElse(WebAdminConfiguration.DEFAULT_HOST), (List<String>)this.additionalRoutes.build());
        }
    }
}

