/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.authentication;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.webadmin.authentication.AuthenticationFilter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class JwtFilter
implements AuthenticationFilter {
    public static final String AUTHORIZATION_HEADER_PREFIX = "Bearer ";
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String OPTIONS = "OPTIONS";
    private final JwtTokenVerifier jwtTokenVerifier;

    @Inject
    public JwtFilter(JwtTokenVerifier jwtTokenVerifier) {
        this.jwtTokenVerifier = jwtTokenVerifier;
    }

    public void handle(Request request, Response response) throws Exception {
        if (!request.requestMethod().equals(OPTIONS)) {
            Optional<String> bearer = Optional.ofNullable(request.headers(AUTHORIZATION_HEADER_NAME)).filter(value -> value.startsWith(AUTHORIZATION_HEADER_PREFIX)).map(value -> value.substring(AUTHORIZATION_HEADER_PREFIX.length()));
            this.checkHeaderPresent(bearer);
            this.checkValidSignature(bearer);
            this.checkIsAdmin(bearer);
            String login = this.jwtTokenVerifier.extractLogin(bearer.get());
            request.attribute("LOGIN", (Object)login);
        }
    }

    private void checkHeaderPresent(Optional<String> bearer) {
        if (!bearer.isPresent()) {
            Spark.halt((int)401, (String)"No Bearer header.");
        }
    }

    private void checkValidSignature(Optional<String> bearer) {
        if (!this.jwtTokenVerifier.verify(bearer.get())) {
            Spark.halt((int)401, (String)"Invalid Bearer header.");
        }
    }

    private void checkIsAdmin(Optional<String> bearer) {
        if (!this.jwtTokenVerifier.hasAttribute("admin", (Object)true, bearer.get())) {
            Spark.halt((int)401, (String)"Non authorized user.");
        }
    }
}

