/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.steveash.guavate.Guavate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.james.task.Hostname;
import org.apache.james.task.TaskExecutionDetails;

public class ExecutionDetailsDto {
    private final TaskExecutionDetails executionDetails;

    public static List<ExecutionDetailsDto> from(List<TaskExecutionDetails> tasksDetails) {
        return (List)tasksDetails.stream().map(ExecutionDetailsDto::new).collect(Guavate.toImmutableList());
    }

    public static ExecutionDetailsDto from(TaskExecutionDetails taskDetails) {
        return new ExecutionDetailsDto(taskDetails);
    }

    private ExecutionDetailsDto(TaskExecutionDetails executionDetails) {
        this.executionDetails = executionDetails;
    }

    public UUID getTaskId() {
        return this.executionDetails.getTaskId().getValue();
    }

    public String getType() {
        return this.executionDetails.getType().asString();
    }

    public String getStatus() {
        return this.executionDetails.getStatus().getValue();
    }

    public String getSubmittedFrom() {
        return this.executionDetails.getSubmittedNode().asString();
    }

    public Optional<String> getExecutedOn() {
        return this.executionDetails.getRanNode().map(Hostname::asString);
    }

    public Optional<String> getCancelledFrom() {
        return this.executionDetails.getCancelRequestedNode().map(Hostname::asString);
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> getAdditionalInformation() {
        return this.executionDetails.getAdditionalInformation();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public ZonedDateTime getSubmitDate() {
        return this.executionDetails.getSubmittedDate();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public Optional<ZonedDateTime> getStartedDate() {
        return this.executionDetails.getStartedDate();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public Optional<ZonedDateTime> getCompletedDate() {
        return this.executionDetails.getCompletedDate();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public Optional<ZonedDateTime> getCanceledDate() {
        return this.executionDetails.getCanceledDate();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public Optional<ZonedDateTime> getFailedDate() {
        return this.executionDetails.getFailedDate();
    }
}

