/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.mdc;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.webadmin.mdc.RequestId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.Request;
import spark.Response;

public class LoggingRequestFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingRequestFilter.class);
    static final String REQUEST_BODY = "request-body";
    static final String METHOD = "method";
    static final String ENDPOINT = "endpoint";
    static final String QUERY_PARAMETERS = "queryParameters";
    static final String IP = "ip";
    static final String REQUEST_ID = "requestId";

    public void handle(Request request, Response response) {
        RequestId requestId = RequestId.random();
        request.attribute(REQUEST_ID, (Object)requestId);
        MDCStructuredLogger.forLogger((Logger)LOGGER).addField(REQUEST_ID, (Object)requestId.asString()).addField(IP, (Object)request.ip()).addField(ENDPOINT, (Object)request.url()).addField(METHOD, (Object)request.requestMethod()).addField("LOGIN", request.attribute("LOGIN")).addField(QUERY_PARAMETERS, (Object)ImmutableSet.copyOf((Collection)request.queryParams())).addField(REQUEST_BODY, (Object)request.body()).log(logger -> logger.info("WebAdmin request received"));
    }
}

