/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.core.healthcheck.ResultStatus;
import org.apache.james.webadmin.PublicRoutes;
import org.apache.james.webadmin.dto.HealthCheckDto;
import org.apache.james.webadmin.dto.HealthCheckExecutionResultDto;
import org.apache.james.webadmin.dto.HeathCheckAggregationExecutionResultDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"Healthchecks"})
@Path(value="/healthcheck")
public class HealthCheckRoutes
implements PublicRoutes {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckRoutes.class);
    public static final String HEALTHCHECK = "/healthcheck";
    public static final String CHECKS = "/checks";
    private static final String PARAM_COMPONENT_NAME = "componentName";
    private final JsonTransformer jsonTransformer;
    private final Set<HealthCheck> healthChecks;

    @Inject
    public HealthCheckRoutes(Set<HealthCheck> healthChecks, JsonTransformer jsonTransformer) {
        this.healthChecks = healthChecks;
        this.jsonTransformer = jsonTransformer;
    }

    @Override
    public String getBasePath() {
        return HEALTHCHECK;
    }

    @Override
    public void define(Service service) {
        service.get(HEALTHCHECK, this::validateHealthChecks, (ResponseTransformer)this.jsonTransformer);
        service.get("/healthcheck/checks/:componentName", this::performHealthCheckForComponent, (ResponseTransformer)this.jsonTransformer);
        service.get("/healthcheck/checks", this::getHealthChecks, (ResponseTransformer)this.jsonTransformer);
    }

    @GET
    @ApiOperation(value="Validate all health checks")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Internal server error - When one check has failed.")})
    public Object validateHealthChecks(Request request, Response response) {
        ImmutableList<Result> results = this.executeHealthChecks();
        ResultStatus status = this.retrieveAggregationStatus((List<Result>)results);
        response.status(this.getCorrespondingStatusCode(status));
        return new HeathCheckAggregationExecutionResultDto(status, this.mapResultToDto((List<Result>)results));
    }

    @GET
    @Path(value="/checks/{componentName}")
    @ApiOperation(value="Perform the component's health check")
    @ApiImplicitParams(value={@ApiImplicitParam(name="componentName", required=true, paramType="path", dataType="String", defaultValue="None", example="/checks/Cassandra%20Backend", value="The URL encoded name of the component to check.")})
    public Object performHealthCheckForComponent(Request request, Response response) {
        String componentName = request.params(PARAM_COMPONENT_NAME);
        HealthCheck healthCheck = this.healthChecks.stream().filter(c -> c.componentName().getName().equals(componentName)).findFirst().orElseThrow(() -> this.throw404(componentName));
        Result result = healthCheck.check();
        this.logFailedCheck(result);
        response.status(this.getCorrespondingStatusCode(result.getStatus()));
        return new HealthCheckExecutionResultDto(result);
    }

    @GET
    @Path(value="/checks")
    @ApiOperation(value="List all health checks")
    @ApiResponse(code=200, message="List of all health checks", response=HealthCheckDto.class, responseContainer="List")
    public Object getHealthChecks(Request request, Response response) {
        return this.healthChecks.stream().map(healthCheck -> new HealthCheckDto(healthCheck.componentName())).collect(Guavate.toImmutableList());
    }

    private int getCorrespondingStatusCode(ResultStatus resultStatus) {
        switch (resultStatus) {
            case HEALTHY: 
            case DEGRADED: {
                return 200;
            }
            case UNHEALTHY: {
                return 503;
            }
        }
        throw new NotImplementedException(resultStatus + " is not supported");
    }

    private void logFailedCheck(Result result) {
        switch (result.getStatus()) {
            case UNHEALTHY: {
                LOGGER.error("HealthCheck failed for {} : {}", (Object)result.getComponentName().getName(), (Object)result.getCause().orElse(""));
                break;
            }
            case DEGRADED: {
                LOGGER.warn("HealthCheck is unstable for {} : {}", (Object)result.getComponentName().getName(), (Object)result.getCause().orElse(""));
                break;
            }
        }
    }

    private ImmutableList<Result> executeHealthChecks() {
        return (ImmutableList)this.healthChecks.stream().map(HealthCheck::check).peek(this::logFailedCheck).collect(ImmutableList.toImmutableList());
    }

    private ResultStatus retrieveAggregationStatus(List<Result> results) {
        return results.stream().map(Result::getStatus).reduce(ResultStatus::merge).orElse(ResultStatus.HEALTHY);
    }

    private ImmutableList<HealthCheckExecutionResultDto> mapResultToDto(List<Result> results) {
        return (ImmutableList)results.stream().map(HealthCheckExecutionResultDto::new).collect(ImmutableList.toImmutableList());
    }

    private HaltException throw404(String componentName) {
        return ErrorResponder.builder().message("Component with name %s cannot be found", componentName).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError();
    }
}

