/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.util.DurationParser;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.ExecutionDetailsDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"Tasks"})
@Path(value=":task")
@Produces(value={"application/json"})
public class TasksRoutes
implements Routes {
    private static final Duration MAXIMUM_AWAIT_TIMEOUT = Duration.ofDays(365L);
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;
    public static final String BASE = "/tasks";

    @Inject
    public TasksRoutes(TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    @Override
    public String getBasePath() {
        return BASE;
    }

    @Override
    public void define(Service service) {
        service.get("/tasks/:id", this::getStatus, (ResponseTransformer)this.jsonTransformer);
        service.get("/tasks/:id/await", this::await, (ResponseTransformer)this.jsonTransformer);
        service.delete("/tasks/:id", this::cancel, (ResponseTransformer)this.jsonTransformer);
        service.get(BASE, this::list, (ResponseTransformer)this.jsonTransformer);
    }

    @GET
    @ApiOperation(value="Listing tasks")
    @ApiImplicitParams(value={@ApiImplicitParam(required=false, paramType="query parameter", dataType="String", defaultValue="None", example="?status=inProgress", value="If present, allow to filter the tasks and keep only the one with a given status. The status are one of [waiting, inProgress, failed, canceled, completed]")})
    @ApiResponses(value={@ApiResponse(code=200, message="A specific class execution details", response=List.class), @ApiResponse(code=400, message="The provided payload is invalid (JSON error or invalid status)"), @ApiResponse(code=404, message="The taskId is not found")})
    public Object list(Request req, Response response) {
        try {
            return ExecutionDetailsDto.from(Optional.ofNullable(req.queryParams("status")).map(TaskManager.Status::fromString).map(arg_0 -> ((TaskManager)this.taskManager).list(arg_0)).orElse(this.taskManager.list()));
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).cause(e).message("Invalid status query parameter").haltError();
        }
    }

    @GET
    @Path(value="/{taskId}")
    @ApiOperation(value="Getting a task execution details")
    @ApiResponses(value={@ApiResponse(code=200, message="A specific class execution details", response=ExecutionDetailsDto.class), @ApiResponse(code=400, message="The taskId is invalid"), @ApiResponse(code=404, message="The taskId is not found")})
    public Object getStatus(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        return this.respondStatus(taskId, () -> this.taskManager.getExecutionDetails(this.getTaskId(req)));
    }

    @GET
    @Path(value="/{taskId}/await")
    @ApiOperation(value="Await, then get a task execution details")
    @ApiResponses(value={@ApiResponse(code=200, message="A specific class execution details", response=ExecutionDetailsDto.class), @ApiResponse(code=400, message="The taskId is invalid or invalid timeout"), @ApiResponse(code=404, message="The taskId is not found"), @ApiResponse(code=408, message="Waiting the the task completion has reached the timeout")})
    public Object await(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        Duration timeout = this.getTimeout(req);
        return this.respondStatus(taskId, () -> this.awaitTask(taskId, timeout));
    }

    private Object respondStatus(TaskId taskId, Supplier<TaskExecutionDetails> executionDetailsSupplier) {
        try {
            TaskExecutionDetails executionDetails = executionDetailsSupplier.get();
            return ExecutionDetailsDto.from(executionDetails);
        }
        catch (TaskNotFoundException e) {
            throw ErrorResponder.builder().message("%s can not be found", taskId.getValue()).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError();
        }
    }

    @DELETE
    @Path(value="/{taskId}")
    @ApiOperation(value="Cancel a given task")
    @ApiResponses(value={@ApiResponse(code=204, message="Task is cancelled"), @ApiResponse(code=400, message="The taskId is invalid")})
    public Object cancel(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        this.taskManager.cancel(taskId);
        return Responses.returnNoContent(response);
    }

    private TaskId getTaskId(Request req) {
        try {
            String id = req.params("id");
            return TaskId.fromString((String)id);
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid task id").haltError();
        }
    }

    private Duration getTimeout(Request req) {
        try {
            Duration timeout = Optional.ofNullable(req.queryParams("timeout")).filter(parameter -> !parameter.isEmpty()).map(rawString -> DurationParser.parse((String)rawString, (ChronoUnit)ChronoUnit.SECONDS)).orElse(MAXIMUM_AWAIT_TIMEOUT);
            this.assertDoesNotExceedMaximumTimeout(timeout);
            return timeout;
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid timeout").haltError();
        }
    }

    private void assertDoesNotExceedMaximumTimeout(Duration timeout) {
        Preconditions.checkState((timeout.compareTo(MAXIMUM_AWAIT_TIMEOUT) <= 0 ? 1 : 0) != 0, (Object)"Timeout should not exceed 365 days");
    }

    private TaskExecutionDetails awaitTask(TaskId taskId, Duration timeout) {
        try {
            return this.taskManager.await(taskId, timeout);
        }
        catch (TaskManager.ReachedTimeoutException e) {
            throw ErrorResponder.builder().statusCode(408).type(ErrorResponder.ErrorType.SERVER_ERROR).message("The timeout has been reached").haltError();
        }
        catch (TaskNotFoundException e) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.SERVER_ERROR).message("The taskId is not found").haltError();
        }
    }
}

