/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.webadmin.FixedPortSupplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FixedPortSupplierTest {
    FixedPortSupplierTest() {
    }

    @Test
    void toIntShouldThrowOnNegativePort() {
        Assertions.assertThatThrownBy(() -> new FixedPortSupplier(-1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void toIntShouldThrowOnNullPort() {
        Assertions.assertThatThrownBy(() -> new FixedPortSupplier(0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void toIntShouldThrowOnTooBigNumbers() {
        Assertions.assertThatThrownBy(() -> new FixedPortSupplier(65536)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void toIntShouldReturnedDesiredPort() {
        int expectedPort = 452;
        Assertions.assertThat((int)new FixedPortSupplier(expectedPort).get().getValue()).isEqualTo(expectedPort);
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(FixedPortSupplier.class).verify();
    }
}

