/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.webadmin.TlsConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TlsConfigurationTest {
    TlsConfigurationTest() {
    }

    @Test
    void buildShouldThrowWhenNotEnabled() {
        Assertions.assertThatThrownBy(() -> TlsConfiguration.builder().build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldThrowWhenEnableWithoutKeystore() {
        Assertions.assertThatThrownBy(() -> TlsConfiguration.builder().build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void selfSignedShouldThrowOnNullKeyStorePath() {
        Assertions.assertThatThrownBy(() -> TlsConfiguration.builder().selfSigned(null, "abc")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void selfSignedShouldThrowOnNullKeyStorePassword() {
        Assertions.assertThatThrownBy(() -> TlsConfiguration.builder().selfSigned("abc", null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldWorkOnSelfSignedHttps() {
        Assertions.assertThat((Object)TlsConfiguration.builder().selfSigned("abcd", "efgh").build()).isEqualTo((Object)new TlsConfiguration("abcd", "efgh", null, null));
    }

    @Test
    void buildShouldWorkOnTrustedHttps() {
        Assertions.assertThat((Object)TlsConfiguration.builder().raw("a", "b", "c", "d").build()).isEqualTo((Object)new TlsConfiguration("a", "b", "c", "d"));
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(TlsConfiguration.class).verify();
    }
}

