/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.webadmin.FixedPortSupplier;
import org.apache.james.webadmin.PortSupplier;
import org.apache.james.webadmin.TlsConfiguration;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WebAdminConfigurationTest {
    static final FixedPortSupplier PORT = new FixedPortSupplier(80);

    WebAdminConfigurationTest() {
    }

    @Test
    void buildShouldThrowWhenNoPortButEnabled() {
        Assertions.assertThatThrownBy(() -> WebAdminConfiguration.builder().enabled().build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldWorkWithoutPortWhenDisabled() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().disabled().build()).extracting(WebAdminConfiguration::isEnabled).isEqualTo((Object)false);
    }

    @Test
    void buildShouldFailOnNoEnable() {
        Assertions.assertThatThrownBy(() -> WebAdminConfiguration.builder().port((PortSupplier)PORT).build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void builderShouldBuildWithRightPort() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((PortSupplier)PORT).build()).extracting(WebAdminConfiguration::getPort).isEqualTo((Object)PORT);
    }

    @Test
    void builderShouldBuildWithEnable() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((PortSupplier)PORT).build()).extracting(WebAdminConfiguration::isEnabled).isEqualTo((Object)true);
    }

    @Test
    void builderShouldAcceptHttps() {
        TlsConfiguration tlsConfiguration = TlsConfiguration.builder().selfSigned("abcd", "efgh").build();
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().tls(tlsConfiguration).port((PortSupplier)PORT).build()).extracting(WebAdminConfiguration::getTlsConfiguration).isEqualTo((Object)tlsConfiguration);
    }

    @Test
    void builderShouldReturnTlsEnableWhenTlsConfiguration() {
        TlsConfiguration tlsConfiguration = TlsConfiguration.builder().selfSigned("abcd", "efgh").build();
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().tls(tlsConfiguration).port((PortSupplier)PORT).build()).extracting(WebAdminConfiguration::getTlsConfiguration).isEqualTo((Object)tlsConfiguration);
    }

    @Test
    void builderShouldReturnTlsDisableWhenNoTlsConfiguration() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((PortSupplier)PORT).build()).extracting(WebAdminConfiguration::isTlsEnabled).isEqualTo((Object)false);
    }

    @Test
    void builderShouldCORSEnabled() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((PortSupplier)PORT).corsEnabled().build()).extracting(WebAdminConfiguration::isEnableCORS).isEqualTo((Object)true);
    }

    @Test
    void builderShouldAcceptAllOriginsByDefault() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((PortSupplier)PORT).corsEnabled().build()).extracting(WebAdminConfiguration::getUrlCORSOrigin).isEqualTo((Object)"*");
    }

    @Test
    void builderShouldCORSDisabled() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((PortSupplier)PORT).corsDisabled().build()).extracting(WebAdminConfiguration::isEnableCORS).isEqualTo((Object)false);
    }

    @Test
    void builderShouldCORSWithOrigin() {
        String origin = "linagora.com";
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((PortSupplier)PORT).corsEnabled().urlCORSOrigin(origin).build()).extracting(WebAdminConfiguration::getUrlCORSOrigin).isEqualTo((Object)origin);
    }

    @Test
    void builderShouldDefineHostWithDefault() {
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((PortSupplier)PORT).build()).extracting(WebAdminConfiguration::getHost).isEqualTo((Object)"localhost");
    }

    @Test
    void builderShouldDefineHostWithSetting() {
        String host = "any.host";
        Assertions.assertThat((Object)WebAdminConfiguration.builder().enabled().port((PortSupplier)PORT).host(host).build()).extracting(WebAdminConfiguration::getHost).isEqualTo((Object)host);
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(WebAdminConfiguration.class).verify();
    }
}

