/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import com.google.common.collect.ImmutableList;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.util.Port;
import org.apache.james.webadmin.PublicRoutes;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.authentication.AuthenticationFilter;
import org.apache.james.webadmin.authentication.NoAuthenticationFilter;
import org.apache.james.webadmin.mdc.LoggingRequestFilter;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;
import spark.Service;

class WebAdminServerTest {
    WebAdminServerTest() {
    }

    @Test
    void getPortShouldThrowWhenNotConfigured() {
        WebAdminServer server = new WebAdminServer(WebAdminConfiguration.TEST_CONFIGURATION, (List)ImmutableList.of(), (AuthenticationFilter)new NoAuthenticationFilter(), (MetricFactory)new RecordingMetricFactory(), LoggingRequestFilter.create());
        Assertions.assertThatThrownBy(() -> ((WebAdminServer)server).getPort()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void getPortShouldReturnPortWhenConfigured() {
        WebAdminServer server = WebAdminUtils.createWebAdminServer(new Routes[0]).start();
        Port port = server.getPort();
        Assertions.assertThat((Object)port).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void aSecondRouteWithSameEndpointShouldNotOverridePreviouslyDefinedRoutes() {
        String firstAnswer = "1";
        String secondAnswer = "2";
        WebAdminServer server = WebAdminUtils.createWebAdminServer(this.myPrivateRouteWithConstAnswer(firstAnswer), this.myPrivateRouteWithConstAnswer(secondAnswer)).start();
        try {
            RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification(server).setBasePath("/myRoute").build();
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).body(CoreMatchers.is((Object)firstAnswer), new Matcher[0]);
        }
        finally {
            server.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void aSecondRouteWithSameEndpointShouldNotOverridePreviouslyDefinedRoutesWhenPublic() {
        String firstAnswer = "1";
        String secondAnswer = "2";
        WebAdminServer server = WebAdminUtils.createWebAdminServer(this.myPrivateRouteWithConstAnswer(firstAnswer), this.myPublicRouteWithConstAnswer(secondAnswer)).start();
        try {
            RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification(server).setBasePath("/myRoute").build();
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).body(CoreMatchers.is((Object)firstAnswer), new Matcher[0]);
        }
        finally {
            server.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void privateRoutesShouldBePrioritizedOveroutes() {
        String firstAnswer = "1";
        String secondAnswer = "2";
        WebAdminServer server = WebAdminUtils.createWebAdminServer(this.myPublicRouteWithConstAnswer(firstAnswer), this.myPrivateRouteWithConstAnswer(secondAnswer)).start();
        try {
            RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification(server).setBasePath("/myRoute").build();
            ((ValidatableResponse)((Response)RestAssured.when().get()).then()).body(CoreMatchers.is((Object)secondAnswer), new Matcher[0]);
        }
        finally {
            server.destroy();
        }
    }

    private Routes myPrivateRouteWithConstAnswer(final String constAnswer) {
        return new Routes(){

            public String getBasePath() {
                return "/myRoute";
            }

            public void define(Service service) {
                service.get("/myRoute", (req, res) -> constAnswer);
            }
        };
    }

    private Routes myPublicRouteWithConstAnswer(final String constAnswer) {
        return new PublicRoutes(){

            public String getBasePath() {
                return "/myRoute";
            }

            public void define(Service service) {
                service.get("/myRoute", (req, res) -> constAnswer);
            }
        };
    }
}

