/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import com.google.common.collect.ImmutableList;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.specification.RequestSpecification;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.util.Port;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.authentication.AuthenticationFilter;
import org.apache.james.webadmin.authentication.NoAuthenticationFilter;
import org.apache.james.webadmin.mdc.LoggingRequestFilter;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class WebAdminUtils {
    public static Startable createWebAdminServer(Routes ... routes) {
        return new ConcurrentSafeWebAdminServerFactory(WebAdminConfiguration.TEST_CONFIGURATION, (List<Routes>)ImmutableList.copyOf((Object[])routes), (AuthenticationFilter)new NoAuthenticationFilter(), (MetricFactory)new RecordingMetricFactory()).createServer();
    }

    public static RequestSpecBuilder buildRequestSpecification(WebAdminServer webAdminServer) {
        return WebAdminUtils.buildRequestSpecification(webAdminServer.getPort());
    }

    public static RequestSpecBuilder buildRequestSpecification(Port port) {
        return new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(WebAdminUtils.defaultConfig()).setPort(port.getValue()).setBasePath("/");
    }

    public static RestAssuredConfig defaultConfig() {
        return RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8));
    }

    public static RequestSpecification spec(Port port) {
        return RestAssured.given().spec(WebAdminUtils.buildRequestSpecification(port).build());
    }

    private static class ConcurrentSafeWebAdminServerFactory {
        private final WebAdminConfiguration configuration;
        private final List<Routes> privateRoutes;
        private final AuthenticationFilter authenticationFilter;
        private final MetricFactory metricFactory;

        private ConcurrentSafeWebAdminServerFactory(WebAdminConfiguration configuration, List<Routes> privateRoutes, AuthenticationFilter authenticationFilter, MetricFactory metricFactory) {
            this.configuration = configuration;
            this.privateRoutes = privateRoutes;
            this.authenticationFilter = authenticationFilter;
            this.metricFactory = metricFactory;
        }

        public Startable createServer() {
            return () -> (WebAdminServer)Mono.fromCallable(this::createServerSingleTry).retryWhen((Retry)Retry.backoff((long)10L, (Duration)Duration.ofMillis(10L))).block();
        }

        public WebAdminServer createServerSingleTry() {
            WebAdminServer webAdminServer = new WebAdminServer(this.configuration, this.privateRoutes, this.authenticationFilter, this.metricFactory, LoggingRequestFilter.create());
            try {
                return webAdminServer.start();
            }
            catch (Exception e) {
                webAdminServer.destroy();
                throw e;
            }
        }
    }

    public static interface Startable {
        public WebAdminServer start();
    }
}

