/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.authentication;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.webadmin.authentication.JwtFilter;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import spark.HaltException;
import spark.Request;
import spark.Response;

class JwtFilterTest {
    private JwtTokenVerifier jwtTokenVerifier;
    private JwtFilter jwtFilter;

    JwtFilterTest() {
    }

    @BeforeEach
    void setUp() {
        this.jwtTokenVerifier = (JwtTokenVerifier)Mockito.mock(JwtTokenVerifier.class);
        this.jwtFilter = new JwtFilter(() -> this.jwtTokenVerifier);
    }

    @Test
    void handleShouldDoNothingOnOptions() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.requestMethod()).thenReturn((Object)new String("OPTIONS"));
        Response response = (Response)Mockito.mock(Response.class);
        this.jwtFilter.handle(request, response);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
    }

    @Test
    void handleShouldRejectRequestWithHeaders() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.requestMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.headers()).thenReturn((Object)ImmutableSet.of());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class))).isInstanceOf(HaltException.class)).extracting(e -> ((HaltException)HaltException.class.cast(e)).statusCode()).isEqualTo((Object)401);
    }

    @Test
    void handleShouldRejectRequestWithBearersHeaders() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.requestMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.headers("Authorization")).thenReturn((Object)"Invalid value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class))).isInstanceOf(HaltException.class)).extracting(e -> ((HaltException)HaltException.class.cast(e)).statusCode()).isEqualTo((Object)401);
    }

    @Test
    void handleShouldRejectRequestWithInvalidBearerHeaders() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.requestMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.headers("Authorization")).thenReturn((Object)"Bearer value");
        Mockito.when((Object)this.jwtTokenVerifier.verifyAndExtractLogin("value")).thenReturn(Optional.empty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class))).isInstanceOf(HaltException.class)).extracting(e -> ((HaltException)HaltException.class.cast(e)).statusCode()).isEqualTo((Object)401);
    }

    @Test
    void handleShouldRejectRequestWithoutAdminClaim() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.requestMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.headers("Authorization")).thenReturn((Object)"Bearer value");
        Mockito.when((Object)this.jwtTokenVerifier.verifyAndExtractLogin("value")).thenReturn(Optional.of("value"));
        Mockito.when((Object)this.jwtTokenVerifier.hasAttribute("admin", (Object)true, "value")).thenReturn((Object)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class))).isInstanceOf(HaltException.class)).extracting(e -> ((HaltException)HaltException.class.cast(e)).statusCode()).isEqualTo((Object)401);
    }

    @Test
    void handleShouldAcceptValidJwt() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.requestMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.headers("Authorization")).thenReturn((Object)"Bearer value");
        Mockito.when((Object)this.jwtTokenVerifier.verifyAndExtractLogin("value")).thenReturn(Optional.of("value"));
        Mockito.when((Object)this.jwtTokenVerifier.hasAttribute("admin", (Object)true, "value")).thenReturn((Object)true);
        this.jwtFilter.handle(request, (Response)Mockito.mock(Response.class));
    }
}

