/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.JsonExtractor;
import spark.Service;

public class ErrorRoutes
implements Routes {
    static final String BASE_URL = "/errors/";
    static final String INTERNAL_SERVER_ERROR = "internalServerError";
    static final String JSON_EXTRACT_EXCEPTION = "jsonExtractException";
    static final String INVALID_ARGUMENT_EXCEPTION = "illegalArgumentException";

    public void define(Service service) {
        this.defineInternalError(service);
        this.defineJsonExtractException(service);
        this.defineIllegalArgumentException(service);
    }

    public String getBasePath() {
        return BASE_URL;
    }

    private void defineInternalError(Service service) {
        service.get("/errors/internalServerError", (req, res) -> {
            throw new RuntimeException();
        });
    }

    private void defineJsonExtractException(Service service) {
        service.get("/errors/jsonExtractException", (req, res) -> new JsonExtractor(Long.class, new Module[0]).parse("a non valid JSON"));
    }

    private void defineIllegalArgumentException(Service service) {
        service.get("/errors/illegalArgumentException", (req, res) -> {
            throw new IllegalArgumentException("Argument is non valid");
        });
    }
}

