/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.ErrorRoutes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ErrorRoutesTest {
    private static final String NOT_FOUND = "notFound";
    private WebAdminServer webAdminServer;

    ErrorRoutesTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.webAdminServer = WebAdminUtils.createWebAdminServer(new ErrorRoutes()).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification(this.webAdminServer).setBasePath("/errors/").build();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
    }

    @Test
    void defineInternalErrorShouldReturnInternalErrorJsonFormat() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("internalServerError", new Object[0])).then()).statusCode(500)).body("statusCode", Matchers.equalTo((Object)500), new Object[0])).body("type", Matchers.equalTo((Object)ErrorResponder.ErrorType.SERVER_ERROR.getType()), new Object[0])).body("message", Matchers.equalTo((Object)"WebAdmin encountered an unexpected internal error"), new Object[0]);
    }

    @Test
    void defineNotFoundShouldReturnNotFoundJsonFormat() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(NOT_FOUND, new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.equalTo((Object)404), new Object[0])).body("type", Matchers.equalTo((Object)ErrorResponder.ErrorType.NOT_FOUND.getType()), new Object[0])).body("message", Matchers.equalTo((Object)"GET /errors/notFound can not be found"), new Object[0]);
    }

    @Test
    void defineJsonExtractExceptionShouldReturnBadRequestJsonFormat() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("jsonExtractException", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.equalTo((Object)400), new Object[0])).body("type", Matchers.equalTo((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.equalTo((Object)"JSON payload of the request is not valid"), new Object[0])).body("details", Matchers.containsString((String)"Unrecognized token 'a': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')"), new Object[0]);
    }

    @Test
    void defineIllegalExceptionShouldReturnBadRequestJsonFormat() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("illegalArgumentException", new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.equalTo((Object)400), new Object[0])).body("type", Matchers.equalTo((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.equalTo((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.containsString((String)"Argument is non valid"), new Object[0]);
    }
}

