/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashSet;
import java.util.Set;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.core.healthcheck.ResultStatus;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.HealthCheckRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class HealthCheckRoutesTest {
    private static final String NAME_1 = "component-1";
    private static final String NAME_2 = "component-2";
    private static final String NAME_3 = "component 3";
    private static final String NAME_3_ESCAPED = "component%203";
    private static final ComponentName COMPONENT_NAME_1 = new ComponentName("component-1");
    private static final ComponentName COMPONENT_NAME_2 = new ComponentName("component-2");
    private static final ComponentName COMPONENT_NAME_3 = new ComponentName("component 3");
    private static final String SAMPLE_CAUSE = "sample cause";
    private WebAdminServer webAdminServer;
    private Set<HealthCheck> healthChecks;

    HealthCheckRoutesTest() {
    }

    private static HealthCheck healthCheck(final Result result) {
        return new HealthCheck(){

            public ComponentName componentName() {
                return result.getComponentName();
            }

            public Publisher<Result> check() {
                return Mono.just((Object)result);
            }
        };
    }

    @BeforeEach
    void setUp() throws Exception {
        this.healthChecks = new HashSet<HealthCheck>();
        this.webAdminServer = WebAdminUtils.createWebAdminServer(new Routes[]{new HealthCheckRoutes(this.healthChecks, new JsonTransformer(new JsonTransformerModule[0]))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification(this.webAdminServer).setBasePath("/healthcheck").build();
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
    }

    @Test
    void validateHealthChecksShouldReturnOkWhenNoHealthChecks() {
        String healthCheckBody = "{\"status\":\"healthy\", \"checks\":[]}";
        String retrieveBody = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)retrieveBody).isEqualTo((Object)healthCheckBody);
    }

    @Test
    void validateHealthChecksShouldReturnOkWhenHealthChecksAreHealthy() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_1)));
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_2)));
        String healthCheckBody = "{\"status\": \"healthy\", \"checks\": [  {    \"componentName\": \"component-1\",    \"escapedComponentName\": \"component-1\",    \"status\": \"healthy\",    \"cause\": null  },  {    \"componentName\": \"component-2\",    \"escapedComponentName\": \"component-2\",    \"status\": \"healthy\",    \"cause\": null}]}";
        String retrieveBody = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)retrieveBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)healthCheckBody);
    }

    @Test
    void validateHealthChecksShouldReturnInternalErrorWhenOneHealthCheckIsUnhealthy() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.unhealthy((ComponentName)COMPONENT_NAME_1, (String)"cause")));
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_2)));
        String healthCheckBody = "{\"status\": \"unhealthy\", \"checks\": [  {    \"componentName\": \"component-1\",    \"escapedComponentName\": \"component-1\",    \"status\": \"unhealthy\",    \"cause\": \"cause\"  },  {    \"componentName\": \"component-2\",    \"escapedComponentName\": \"component-2\",    \"status\": \"healthy\",    \"cause\": null}]}";
        String retrieveBody = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(503)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)retrieveBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)healthCheckBody);
    }

    @Test
    void validateHealthChecksShouldReturnInternalErrorWhenAllHealthChecksAreUnhealthy() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.unhealthy((ComponentName)COMPONENT_NAME_1, (String)"cause")));
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.unhealthy((ComponentName)COMPONENT_NAME_2, (String)SAMPLE_CAUSE)));
        String healthCheckBody = "{\"status\": \"unhealthy\", \"checks\": [  {    \"componentName\": \"component-1\",    \"escapedComponentName\": \"component-1\",    \"status\": \"unhealthy\",    \"cause\": \"cause\"  },  {    \"componentName\": \"component-2\",    \"escapedComponentName\": \"component-2\",    \"status\": \"unhealthy\",    \"cause\": \"sample cause\"}]}";
        String retrieveBody = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(503)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)retrieveBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)healthCheckBody);
    }

    @Test
    void validateHealthChecksShouldReturnInternalErrorWhenOneHealthCheckIsDegraded() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.degraded((ComponentName)COMPONENT_NAME_1, (String)"cause")));
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_2)));
        String healthCheckBody = "{\"status\": \"degraded\", \"checks\": [  {    \"componentName\": \"component-1\",    \"escapedComponentName\": \"component-1\",    \"status\": \"degraded\",    \"cause\": \"cause\"  },  {    \"componentName\": \"component-2\",    \"escapedComponentName\": \"component-2\",    \"status\": \"healthy\",    \"cause\": null}]}";
        String retrieveBody = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)retrieveBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)healthCheckBody);
    }

    @Test
    void validateHealthChecksShouldReturnInternalErrorWhenAllHealthCheckAreDegraded() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.degraded((ComponentName)COMPONENT_NAME_1, (String)"cause")));
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.degraded((ComponentName)COMPONENT_NAME_2, (String)"cause")));
        String healthCheckBody = "{\"status\": \"degraded\", \"checks\": [  {    \"componentName\": \"component-1\",    \"escapedComponentName\": \"component-1\",    \"status\": \"degraded\",    \"cause\": \"cause\"  },  {    \"componentName\": \"component-2\",    \"escapedComponentName\": \"component-2\",    \"status\": \"degraded\",    \"cause\": \"cause\"}]}";
        String retrieveBody = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)retrieveBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)healthCheckBody);
    }

    @Test
    void validateHealthChecksShouldReturnStatusUnHealthyWhenOneIsUnHealthyAndOtherIsDegraded() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.degraded((ComponentName)COMPONENT_NAME_1, (String)"cause")));
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.unhealthy((ComponentName)COMPONENT_NAME_2, (String)"cause")));
        String healthCheckBody = "{\"status\": \"unhealthy\", \"checks\": [  {    \"componentName\": \"component-1\",    \"escapedComponentName\": \"component-1\",    \"status\": \"degraded\",    \"cause\": \"cause\"  },  {    \"componentName\": \"component-2\",    \"escapedComponentName\": \"component-2\",    \"status\": \"unhealthy\",    \"cause\": \"cause\"}]}";
        String retrieveBody = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(503)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)retrieveBody).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)healthCheckBody);
    }

    @Test
    void performHealthCheckShouldReturnOkWhenHealthCheckIsHealthy() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_1)));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("componentName", (Object)COMPONENT_NAME_1.getName()).when().get("/checks/{componentName}", new Object[0])).then()).statusCode(200)).body("componentName", Matchers.equalTo((Object)NAME_1), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)NAME_1), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.HEALTHY.getValue()), new Object[0])).body("cause", Matchers.is((Matcher)Matchers.nullValue()), new Object[0]);
    }

    @Test
    void performHealthCheckShouldReturnNotFoundWhenComponentNameIsUnknown() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("componentName", (Object)"unknown").when().get("/checks/{componentName}", new Object[0])).then()).statusCode(404)).body("details", Matchers.is((Matcher)Matchers.nullValue()), new Object[0])).body("type", Matchers.equalTo((Object)"notFound"), new Object[0])).body("message", Matchers.equalTo((Object)"Component with name unknown cannot be found"), new Object[0])).body("statusCode", Matchers.is((Object)404), new Object[0]);
    }

    @Test
    void performHealthCheckShouldReturnInternalErrorWhenHealthCheckIsDegraded() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.degraded((ComponentName)COMPONENT_NAME_1, (String)"the cause")));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("componentName", (Object)COMPONENT_NAME_1.getName()).when().get("/checks/{componentName}", new Object[0])).then()).statusCode(200)).body("componentName", Matchers.equalTo((Object)NAME_1), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)NAME_1), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.DEGRADED.getValue()), new Object[0])).body("cause", Matchers.equalTo((Object)"the cause"), new Object[0]);
    }

    @Test
    void performHealthCheckShouldReturnInternalErrorWhenHealthCheckIsUnhealthy() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.unhealthy((ComponentName)COMPONENT_NAME_1, (String)SAMPLE_CAUSE)));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("componentName", (Object)COMPONENT_NAME_1.getName()).when().get("/checks/{componentName}", new Object[0])).then()).statusCode(503)).body("componentName", Matchers.equalTo((Object)NAME_1), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)NAME_1), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.UNHEALTHY.getValue()), new Object[0])).body("cause", Matchers.is((Object)SAMPLE_CAUSE), new Object[0]);
    }

    @Test
    void performHealthCheckShouldReturnProperlyEscapedComponentName() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_3)));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("componentName", (Object)COMPONENT_NAME_3.getName()).when().get("/checks/{componentName}", new Object[0])).then()).body("componentName", Matchers.equalTo((Object)NAME_3), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)NAME_3_ESCAPED), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.HEALTHY.getValue()), new Object[0])).body("cause", Matchers.is((Matcher)Matchers.nullValue()), new Object[0]);
    }

    @Test
    void performHealthCheckShouldWorkWithEscapedPathParam() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_3)));
        RestAssured.requestSpecification.urlEncodingEnabled(false);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("componentName", (Object)NAME_3_ESCAPED).when().get("/checks/{componentName}", new Object[0])).then()).body("componentName", Matchers.equalTo((Object)NAME_3), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)NAME_3_ESCAPED), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.HEALTHY.getValue()), new Object[0])).body("cause", Matchers.is((Matcher)Matchers.nullValue()), new Object[0]);
    }

    @Test
    void getHealthchecksShouldReturnEmptyWhenNoHealthChecks() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/checks", new Object[0])).then()).body(Matchers.is((Object)"[]"), new Matcher[0])).body("", Matchers.hasSize((int)0), new Object[0])).statusCode(200);
    }

    @Test
    void getHealthchecksShouldReturnHealthCheckWhenHealthCheckPresent() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_3)));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/checks", new Object[0])).then()).body("", Matchers.hasSize((int)1), new Object[0])).body("componentName[0]", Matchers.equalTo((Object)NAME_3), new Object[0])).body("escapedComponentName[0]", Matchers.equalTo((Object)NAME_3_ESCAPED), new Object[0])).statusCode(200);
    }

    @Test
    void getHealthchecksShouldReturnHealthChecksWhenHealthChecksPresent() {
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_2)));
        this.healthChecks.add(HealthCheckRoutesTest.healthCheck(Result.healthy((ComponentName)COMPONENT_NAME_3)));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/checks", new Object[0])).then()).body("", Matchers.hasSize((int)2), new Object[0])).statusCode(200);
    }
}

