/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.task.CompletedTask;
import org.apache.james.task.FailedTask;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryReferenceTask;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.Task;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class TasksRoutesTest {
    private static final String HOSTNAME = "foo";
    private MemoryTaskManager taskManager;
    private WebAdminServer webAdminServer;
    private CountDownLatch waitingForResultLatch;

    TasksRoutesTest() {
    }

    @BeforeEach
    void setUp() {
        this.taskManager = new MemoryTaskManager(new Hostname(HOSTNAME));
        this.webAdminServer = WebAdminUtils.createWebAdminServer(new Routes[]{new TasksRoutes((TaskManager)this.taskManager, new JsonTransformer(new JsonTransformerModule[0]), DTOConverter.of((DTOModule[])new DTOModule[0]))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification(this.webAdminServer).setBasePath("/tasks").build();
        this.waitingForResultLatch = new CountDownLatch(1);
    }

    @AfterEach
    void tearDown() {
        this.waitingForResultLatch.countDown();
        this.taskManager.stop();
        this.webAdminServer.destroy();
    }

    @Test
    void listShouldReturnEmptyWhenNoTask() {
        ((ValidatableResponse)((Response)RestAssured.when().get()).then()).body("", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void listShouldReturnTaskDetailsWhenTaskInProgress() throws Exception {
        CountDownLatch taskInProgressLatch = new CountDownLatch(1);
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            taskInProgressLatch.countDown();
            this.waitForResult();
            return Task.Result.COMPLETED;
        }));
        taskInProgressLatch.await();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).body("", Matchers.hasSize((int)1), new Object[0])).body("[0].status", Matchers.is((Object)TaskManager.Status.IN_PROGRESS.getValue()), new Object[0])).body("[0].taskId", Matchers.is((Object)taskId.asString()), new Object[0])).body("[0].class", Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())), new Object[0])).body("[0].submittedFrom", Matchers.is((Object)HOSTNAME), new Object[0])).body("[0].executedOn", Matchers.is((Object)HOSTNAME), new Object[0])).body("[0].cancelledFrom", Matchers.nullValue(), new Object[0]);
    }

    @Test
    void listShouldBeSorted() throws Exception {
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(10L);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).body("", Matchers.hasSize((int)3), new Object[0])).body("[0].taskId", Matchers.is((Object)taskId3.asString()), new Object[0])).body("[1].taskId", Matchers.is((Object)taskId2.asString()), new Object[0])).body("[2].taskId", Matchers.is((Object)taskId1.asString()), new Object[0]);
    }

    @Test
    void listShouldSupportOffsetAndLimit() throws Exception {
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(10L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(10L);
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(10L);
        TaskId taskId4 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(10L);
        TaskId taskId5 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(10L);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("offset", new Object[]{1}).param("limit", new Object[]{2}).when().get()).then()).statusCode(200)).body("", Matchers.hasSize((int)2), new Object[0])).body("[0].taskId", Matchers.is((Object)taskId4.asString()), new Object[0])).body("[1].taskId", Matchers.is((Object)taskId3.asString()), new Object[0]);
    }

    @Test
    void listShouldFilterByType() throws Exception {
        TaskId taskId1 = this.taskManager.submit((Task)new CompletedTask());
        Thread.sleep(10L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(10L);
        TaskId taskId3 = this.taskManager.submit((Task)new FailedTask());
        Thread.sleep(10L);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("type", new Object[]{"failed"}).when().get()).then()).statusCode(200)).body("", Matchers.hasSize((int)1), new Object[0])).body("[0].taskId", Matchers.is((Object)taskId3.asString()), new Object[0]);
    }

    private void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForResult() {
        this.await(this.waitingForResultLatch);
    }

    @Test
    void listShouldListTaskWhenStatusFilter() throws Exception {
        CountDownLatch inProgressLatch = new CountDownLatch(1);
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            inProgressLatch.countDown();
            this.waitForResult();
            return Task.Result.COMPLETED;
        }));
        inProgressLatch.await();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("status", new Object[]{TaskManager.Status.IN_PROGRESS.getValue()}).when().get()).then()).statusCode(200)).body("", Matchers.hasSize((int)1), new Object[0])).body("[0].status", Matchers.is((Object)TaskManager.Status.IN_PROGRESS.getValue()), new Object[0])).body("[0].taskId", Matchers.is((Object)taskId.asString()), new Object[0])).body("[0].type", Matchers.is((Object)MemoryReferenceTask.TYPE.asString()), new Object[0]);
    }

    @Test
    void listShouldReturnEmptyWhenNonMatchingStatusFilter() throws Exception {
        CountDownLatch inProgressLatch = new CountDownLatch(1);
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            inProgressLatch.countDown();
            this.waitForResult();
            return Task.Result.COMPLETED;
        }));
        inProgressLatch.await();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("status", new Object[]{TaskManager.Status.WAITING.getValue()}).when().get()).then()).statusCode(200)).body("", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void getShouldReturnTaskDetails() throws Exception {
        CountDownLatch inProgressLatch = new CountDownLatch(1);
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            inProgressLatch.countDown();
            this.waitForResult();
            return Task.Result.COMPLETED;
        }));
        inProgressLatch.await();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/" + taskId.getValue(), new Object[0])).then()).statusCode(200)).body("status", Matchers.is((Object)"inProgress"), new Object[0]);
    }

    @Test
    void getAwaitShouldAwaitTaskCompletion() {
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return Task.Result.COMPLETED;
        }));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/" + taskId.getValue() + "/await", new Object[0])).then()).statusCode(200)).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }

    @Test
    void getAwaitWithTimeoutShouldAwaitTaskCompletion() {
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return Task.Result.COMPLETED;
        }));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("timeout", new Object[]{"2s"}).when().get("/" + taskId.getValue() + "/await", new Object[0])).then()).statusCode(200)).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }

    @Test
    void getAwaitWithInvalidTimeoutShouldReturnAnError() {
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("timeout", new Object[]{"-5"}).when().get("/" + taskId.getValue() + "/await", new Object[0])).then()).statusCode(400)).body("message", Matchers.containsString((String)"Invalid timeout"), new Object[0])).body("details", Matchers.containsString((String)"Duration amount should be positive"), new Object[0]);
    }

    @Test
    void getAwaitWithATooBigTimeoutShouldReturnAnError() {
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("timeout", new Object[]{"5y"}).when().get("/" + taskId.getValue() + "/await", new Object[0])).then()).statusCode(400)).body("message", Matchers.containsString((String)"Invalid timeout"), new Object[0])).body("details", Matchers.containsString((String)"Timeout should not exceed 365 days"), new Object[0]);
    }

    @Test
    void getAwaitWithAShorterTimeoutShouldReturnTimeout() {
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return Task.Result.COMPLETED;
        }));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("timeout", new Object[]{"1"}).when().get("/" + taskId.getValue() + "/await", new Object[0])).then()).statusCode(408)).body("message", Matchers.is((Object)"The timeout has been reached"), new Object[0]);
    }

    @Test
    void getAwaitWithANonExistingTaskShouldReturnNotFound() {
        String unknownTaskId = TaskId.generateTaskId().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/" + unknownTaskId + "/await", new Object[0])).then()).statusCode(404)).body("message", Matchers.is((Object)"The taskId is not found"), new Object[0]);
    }

    @Test
    void getAwaitShouldNotFailUponError() {
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            throw new RuntimeException();
        }));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/" + taskId.getValue() + "/await", new Object[0])).then()).statusCode(200)).body("status", Matchers.is((Object)"failed"), new Object[0]);
    }

    @Test
    void getAwaitShouldNotFailUponFutureError() {
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException();
        }));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/" + taskId.getValue() + "/await", new Object[0])).then()).statusCode(200)).body("status", Matchers.is((Object)"failed"), new Object[0]);
    }

    @Test
    void deleteShouldReturnOk() {
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            this.waitForResult();
            return Task.Result.COMPLETED;
        }));
        ((ValidatableResponse)((Response)RestAssured.when().delete("/" + taskId.getValue(), new Object[0])).then()).statusCode(204);
    }

    @Test
    void deleteShouldCancelMatchingTask() {
        CountDownLatch inProgressLatch = new CountDownLatch(1);
        TaskId taskId = this.taskManager.submit((Task)new MemoryReferenceTask(() -> {
            try {
                inProgressLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Task.Result.COMPLETED;
        }));
        RestAssured.with().delete("/" + taskId.getValue(), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/" + taskId.getValue(), new Object[0])).then()).statusCode(200)).body("status", Matchers.is((Matcher)Matchers.oneOf((Object[])new String[]{"canceledRequested", "canceled"})), new Object[0]);
        inProgressLatch.countDown();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/" + taskId.getValue() + "/await", new Object[0])).then()).statusCode(200)).body("status", Matchers.is((Object)"canceled"), new Object[0])).body("cancelledFrom", Matchers.is((Object)HOSTNAME), new Object[0]);
    }

    @Test
    void getShouldReturnNotFoundWhenIdDoesNotExist() {
        String taskId = UUID.randomUUID().toString();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/" + taskId, new Object[0])).then()).statusCode(404)).body("statusCode", Matchers.is((Object)404), new Object[0])).body("type", Matchers.is((Object)"notFound"), new Object[0])).body("message", Matchers.is((Object)String.format("%s can not be found", taskId)), new Object[0]);
    }

    @Test
    void getShouldReturnErrorWhenInvalidId() {
        String taskId = "invalid";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/" + taskId, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid task id"), new Object[0]);
    }

    @Test
    void deleteShouldReturnOkWhenNonExistingId() {
        String taskId = UUID.randomUUID().toString();
        ((ValidatableResponse)((Response)RestAssured.when().delete("/" + taskId, new Object[0])).then()).statusCode(204);
    }

    @Test
    void deleteShouldReturnAnErrorOnInvalidId() {
        String taskId = "invalid";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete("/" + taskId, new Object[0])).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid task id"), new Object[0]);
    }

    @Test
    void listShouldReturnErrorWhenNonExistingStatus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("status", new Object[]{"invalid"}).get()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid status query parameter"), new Object[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"failedBefore", "failedAfter", "startedBefore", "startedAfter", "completedBefore", "completedAfter", "submittedBefore", "submittedAfter"})
    void listShouldRejectInvalidDateParameter(String paramName) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param(paramName, new Object[]{"invalid"}).get()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)"InvalidArgument"), new Object[0])).body("message", Matchers.is((Object)"Invalid status query parameter"), new Object[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"failedBefore", "failedAfter", "startedBefore", "startedAfter", "completedBefore", "completedAfter", "submittedBefore", "submittedAfter"})
    void listShouldAcceptValidDateParameter(String paramName) {
        ((ValidatableResponse)((Response)RestAssured.given().param(paramName, new Object[]{ZonedDateTime.now().toString()}).get()).then()).statusCode(200);
    }

    @Test
    void getTasksShouldFilterWhenSubmitBefore() throws Exception {
        ZonedDateTime t1 = ZonedDateTime.now();
        Thread.sleep(1L);
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(1L);
        ZonedDateTime t2 = ZonedDateTime.now();
        Thread.sleep(1L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(1L);
        ZonedDateTime t3 = ZonedDateTime.now();
        Thread.sleep(1L);
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(1L);
        ZonedDateTime t4 = ZonedDateTime.now();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("submittedBefore", new Object[]{t3.toString()}).get()).then()).statusCode(200)).body("taskId", Matchers.contains((Object[])new String[]{taskId2.asString(), taskId1.asString()}), new Object[0]);
    }

    @Test
    void getTasksShouldFilterWhenSubmitAfter() throws Exception {
        ZonedDateTime t1 = ZonedDateTime.now();
        Thread.sleep(1L);
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(1L);
        ZonedDateTime t2 = ZonedDateTime.now();
        Thread.sleep(1L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(1L);
        ZonedDateTime t3 = ZonedDateTime.now();
        Thread.sleep(1L);
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(1L);
        ZonedDateTime t4 = ZonedDateTime.now();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("submittedAfter", new Object[]{t3.toString()}).get()).then()).statusCode(200)).body("taskId", Matchers.contains((Object[])new String[]{taskId3.asString()}), new Object[0]);
    }

    @Test
    void getTasksShouldFilterWhenCompletedBefore() throws Exception {
        ZonedDateTime t1 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t2 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t3 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t4 = ZonedDateTime.now();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("completedBefore", new Object[]{t3.toString()}).get()).then()).statusCode(200)).body("taskId", Matchers.contains((Object[])new String[]{taskId2.asString(), taskId1.asString()}), new Object[0]);
    }

    @Test
    void getTasksShouldFilterWhenCompletedAfter() throws Exception {
        ZonedDateTime t1 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t2 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t3 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t4 = ZonedDateTime.now();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("completedAfter", new Object[]{t3.toString()}).get()).then()).statusCode(200)).body("taskId", Matchers.contains((Object[])new String[]{taskId3.asString()}), new Object[0]);
    }

    @Test
    void getTasksShouldFilterWhenFailedBefore() throws Exception {
        ZonedDateTime t1 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(100L);
        ZonedDateTime t2 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(100L);
        ZonedDateTime t3 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(100L);
        ZonedDateTime t4 = ZonedDateTime.now();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("failedBefore", new Object[]{t3.toString()}).get()).then()).statusCode(200)).body("taskId", Matchers.contains((Object[])new String[]{taskId2.asString(), taskId1.asString()}), new Object[0]);
    }

    @Test
    void getTasksShouldFilterWhenFailedAfter() throws Exception {
        ZonedDateTime t1 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(100L);
        ZonedDateTime t2 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(100L);
        ZonedDateTime t3 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(100L);
        ZonedDateTime t4 = ZonedDateTime.now();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("failedAfter", new Object[]{t3.toString()}).get()).then()).statusCode(200)).body("taskId", Matchers.contains((Object[])new String[]{taskId3.asString()}), new Object[0]);
    }

    @Test
    void getTasksShouldFilterWhenStartedBefore() throws Exception {
        ZonedDateTime t1 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t2 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(100L);
        ZonedDateTime t3 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t4 = ZonedDateTime.now();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("startedBefore", new Object[]{t3.toString()}).get()).then()).statusCode(200)).body("taskId", Matchers.contains((Object[])new String[]{taskId2.asString(), taskId1.asString()}), new Object[0]);
    }

    @Test
    void getTasksShouldFilterWhenStartedAfter() throws Exception {
        ZonedDateTime t1 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId1 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t2 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId2 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.COMPLETED));
        Thread.sleep(100L);
        ZonedDateTime t3 = ZonedDateTime.now();
        Thread.sleep(100L);
        TaskId taskId3 = this.taskManager.submit((Task)new MemoryReferenceTask(() -> Task.Result.PARTIAL));
        Thread.sleep(100L);
        ZonedDateTime t4 = ZonedDateTime.now();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("startedAfter", new Object[]{t3.toString()}).get()).then()).statusCode(200)).body("taskId", Matchers.contains((Object[])new String[]{taskId3.asString()}), new Object[0]);
    }
}

