/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.tasks;

import org.apache.james.task.Task;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import spark.Request;

class TaskFromRequestRegistryTest {
    static final Task TASK_1 = (Task)Mockito.mock(Task.class);
    static final Task TASK_2 = (Task)Mockito.mock(Task.class);
    static final TaskRegistrationKey KEY_1 = TaskRegistrationKey.of((String)"task1");
    static final TaskRegistrationKey KEY_2 = TaskRegistrationKey.of((String)"task2");
    Request request;
    TaskFromRequestRegistry taskFromRequestRegistry;
    TaskFromRequestRegistry singleTaskFromRequestRegistry;

    TaskFromRequestRegistryTest() {
    }

    @BeforeEach
    void setUp() {
        this.request = (Request)Mockito.mock(Request.class);
        this.taskFromRequestRegistry = TaskFromRequestRegistry.builder().register(KEY_1, any -> TASK_1).register(KEY_2, any -> TASK_2).build();
        this.singleTaskFromRequestRegistry = TaskFromRequestRegistry.of((TaskRegistrationKey)KEY_1, any -> TASK_1);
    }

    @Test
    void buildShouldThrowWhenNoTasks() {
        Assertions.assertThatThrownBy(() -> TaskFromRequestRegistry.builder().build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void generateShouldThrowFormattedMessageWhenNoTaskParamAndSeveralOptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskFromRequestRegistry.fromRequest(this.request)).isInstanceOf(IllegalArgumentException.class)).hasMessage("'action' query parameter is compulsory. Supported values are [task1, task2]");
    }

    @Test
    void generateShouldThrowFormattedMessageWhenNoTaskParam() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleTaskFromRequestRegistry.fromRequest(this.request)).isInstanceOf(IllegalArgumentException.class)).hasMessage("'action' query parameter is compulsory. Supported values are [task1]");
    }

    @Test
    void generateShouldThrowWhenCustomParameterValueIsInvalid() {
        TaskFromRequestRegistry taskFromRequestRegistry = TaskFromRequestRegistry.builder().parameterName("custom").register(KEY_1, any -> TASK_1).build();
        Mockito.when((Object)this.request.queryParams("custom")).thenReturn((Object)"unknown");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> taskFromRequestRegistry.fromRequest(this.request)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid value supplied for query parameter 'custom': unknown. Supported values are [task1]");
    }

    @Test
    void generateShouldThrowWhenCustomParameterNotSpecified() {
        TaskFromRequestRegistry taskFromRequestRegistry = TaskFromRequestRegistry.builder().parameterName("custom").register(KEY_1, any -> TASK_1).build();
        Mockito.when((Object)this.request.queryParams("action")).thenReturn((Object)"unknown");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> taskFromRequestRegistry.fromRequest(this.request)).isInstanceOf(IllegalArgumentException.class)).hasMessage("'custom' query parameter is compulsory. Supported values are [task1]");
    }

    @Test
    void generateShouldThrowFormattedMessageWhenUnknownTaskParamAndSeveralOptions() {
        Mockito.when((Object)this.request.queryParams("action")).thenReturn((Object)"unknown");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskFromRequestRegistry.fromRequest(this.request)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid value supplied for query parameter 'action': unknown. Supported values are [task1, task2]");
    }

    @Test
    void generateShouldThrowFormattedMessageWhenUnknownTaskParam() {
        Mockito.when((Object)this.request.queryParams("action")).thenReturn((Object)"unknown");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleTaskFromRequestRegistry.fromRequest(this.request)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid value supplied for query parameter 'action': unknown. Supported values are [task1]");
    }

    @Test
    void generateShouldThrowWhenEmptyTaskParam() {
        Mockito.when((Object)this.request.queryParams("action")).thenReturn((Object)"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleTaskFromRequestRegistry.fromRequest(this.request)).isInstanceOf(IllegalArgumentException.class)).hasMessage("'action' query parameter cannot be empty or blank. Supported values are [task1]");
    }

    @Test
    void generateShouldThrowWhenBlankTaskParam() {
        Mockito.when((Object)this.request.queryParams("action")).thenReturn((Object)" ");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleTaskFromRequestRegistry.fromRequest(this.request)).isInstanceOf(IllegalArgumentException.class)).hasMessage("'action' query parameter cannot be empty or blank. Supported values are [task1]");
    }

    @Test
    void generateShouldCreateCorrespondingTask() throws Exception {
        Mockito.when((Object)this.request.queryParams("action")).thenReturn((Object)"task1");
        Assertions.assertThat((Object)this.singleTaskFromRequestRegistry.fromRequest(this.request)).isSameAs((Object)TASK_1);
    }

    @Test
    void generateShouldHandleCustomTaskParameter() throws Exception {
        TaskFromRequestRegistry taskFromRequestRegistry = TaskFromRequestRegistry.builder().parameterName("custom").register(KEY_1, any -> TASK_1).build();
        Mockito.when((Object)this.request.queryParams("custom")).thenReturn((Object)"task1");
        Assertions.assertThat((Object)taskFromRequestRegistry.fromRequest(this.request)).isSameAs((Object)TASK_1);
    }
}

