/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.tasks;

import org.apache.james.task.Task;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.eclipse.jetty.http.HttpHeader;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import spark.Request;
import spark.Response;

class TaskFromRequestTest {
    static final Task TASK = (Task)Mockito.mock(Task.class);
    static final String UUID_VALUE = "ce5316cb-c924-40eb-9ca0-c5828e276297";

    TaskFromRequestTest() {
    }

    @Test
    void handleShouldReturnCreatedWithTaskIdHeader() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        TaskFromRequest taskFromRequest = any -> TASK;
        TaskManager taskManager = (TaskManager)Mockito.mock(TaskManager.class);
        Mockito.when((Object)taskManager.submit(TASK)).thenReturn((Object)TaskId.fromString((String)UUID_VALUE));
        taskFromRequest.asRoute(taskManager).handle(request, response);
        ((Response)Mockito.verify((Object)response)).status(201);
        ((Response)Mockito.verify((Object)response)).header(HttpHeader.LOCATION.asString(), "/tasks/ce5316cb-c924-40eb-9ca0-c5828e276297");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
    }
}

