/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.tasks;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskRegistrationKeyTest {
    TaskRegistrationKeyTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(TaskRegistrationKey.class).verify();
    }

    @Test
    void ofShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> TaskRegistrationKey.of(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void ofShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> TaskRegistrationKey.of((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void asStringShouldReturnRawValue() {
        Assertions.assertThat((String)TaskRegistrationKey.of((String)"reindex").asString()).isEqualTo("reindex");
    }
}

