/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.utils;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import spark.HaltException;

class ErrorResponderTest {
    static final Optional<String> NO_CAUSE = Optional.empty();

    ErrorResponderTest() {
    }

    @Test
    void haltErrorShouldThrowWhenNoStatusCode() {
        Assertions.assertThatThrownBy(() -> ErrorResponder.builder().haltError()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void haltErrorShouldThrowWhenNoType() {
        Assertions.assertThatThrownBy(() -> ErrorResponder.builder().statusCode(400).haltError()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void haltErrorShouldThrowWhenNoMessage() {
        Assertions.assertThatThrownBy(() -> ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).haltError()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void haltErrorShouldReturnBodyWithStatusCodeWhenSetting() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Error").haltError()).isInstanceOf(HaltException.class)).matches(e -> this.hasStatus((Throwable)e, 404))).matches(e -> this.bodyHasErrorDetail((Throwable)e, new ErrorResponder.ErrorDetail(404, "InvalidArgument", "Error", NO_CAUSE)));
    }

    @Test
    void haltErrorShouldReturnBodyWithErrorTypeWhenSetting() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.WRONG_STATE).message("Error").haltError()).isInstanceOf(HaltException.class)).matches(e -> this.hasStatus((Throwable)e, 400))).matches(e -> this.bodyHasErrorDetail((Throwable)e, new ErrorResponder.ErrorDetail(400, "WrongState", "Error", NO_CAUSE)));
    }

    @Test
    void haltErrorShouldReturnBodyWithErrorMessageWhenSetting() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("It has error").haltError()).isInstanceOf(HaltException.class)).matches(e -> this.hasStatus((Throwable)e, 400))).matches(e -> this.bodyHasErrorDetail((Throwable)e, new ErrorResponder.ErrorDetail(400, "InvalidArgument", "It has error", NO_CAUSE)));
    }

    @Test
    void haltErrorShouldReturnBodyWithCauseTypeWhenSetting() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Error").cause((Exception)new IllegalArgumentException("The input data is invalid")).haltError()).isInstanceOf(HaltException.class)).matches(e -> this.hasStatus((Throwable)e, 400))).matches(e -> this.bodyHasErrorDetail((Throwable)e, new ErrorResponder.ErrorDetail(400, "InvalidArgument", "Error", Optional.of("The input data is invalid"))));
    }

    @Test
    void haltErrorShouldReturnBodyWithErrorDetail() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Error").cause((Exception)new IllegalArgumentException("The input data is invalid")).haltError()).isInstanceOf(HaltException.class)).matches(e -> this.hasStatus((Throwable)e, 400))).matches(e -> this.bodyHasErrorDetail((Throwable)e, new ErrorResponder.ErrorDetail(400, "InvalidArgument", "Error", Optional.of("The input data is invalid"))));
    }

    @Test
    void haltShouldFormatMessage() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Error %s", new Object[]{"bip"}).cause((Exception)new IllegalArgumentException("The input data is invalid")).haltError()).isInstanceOf(HaltException.class)).matches(e -> this.hasStatus((Throwable)e, 400))).matches(e -> this.bodyHasErrorDetail((Throwable)e, new ErrorResponder.ErrorDetail(400, "InvalidArgument", "Error bip", Optional.of("The input data is invalid"))));
    }

    private boolean hasStatus(Throwable throwable, int status) {
        HaltException haltException = (HaltException)throwable;
        return Objects.equals(haltException.statusCode(), status);
    }

    private boolean bodyHasErrorDetail(Throwable throwable, ErrorResponder.ErrorDetail errorDetail) {
        HaltException haltException = (HaltException)throwable;
        DocumentContext jsonPath = JsonPath.parse((String)haltException.body());
        return errorDetail.equals((Object)new ErrorResponder.ErrorDetail(((Integer)jsonPath.read("$.statusCode", new Predicate[0])).intValue(), (String)jsonPath.read("$.type", new Predicate[0]), (String)jsonPath.read("$.message", new Predicate[0]), Optional.ofNullable((String)jsonPath.read("$.details", new Predicate[0]))));
    }
}

