/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.google.common.base.Preconditions;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JsonExtractorTest {
    private JsonExtractor<Request> jsonExtractor;

    JsonExtractorTest() {
    }

    @BeforeEach
    void setUp() {
        this.jsonExtractor = new JsonExtractor(Request.class, new Module[0]);
    }

    @Test
    void parseShouldThrowOnNullInput() {
        Assertions.assertThatThrownBy(() -> this.jsonExtractor.parse(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void parseShouldThrowOnEmptyInput() {
        Assertions.assertThatThrownBy(() -> this.jsonExtractor.parse("")).isInstanceOf(JsonExtractException.class);
    }

    @Test
    void parseShouldThrowOnBrokenJson() {
        Assertions.assertThatThrownBy(() -> this.jsonExtractor.parse("{\"field1\":\"broken")).isInstanceOf(JsonExtractException.class);
    }

    @Test
    void parseShouldThrowOnEmptyJson() {
        Assertions.assertThatThrownBy(() -> this.jsonExtractor.parse("{}")).isInstanceOf(JsonExtractException.class);
    }

    @Test
    void parseShouldThrowOnMissingMandatoryField() {
        Assertions.assertThatThrownBy(() -> this.jsonExtractor.parse("{\"field1\":\"any\"}")).isInstanceOf(JsonExtractException.class);
    }

    @Test
    void parseShouldThrowOnValidationProblemIllegalArgumentException() {
        Assertions.assertThatThrownBy(() -> this.jsonExtractor.parse("{\"field1\":\"\",\"field2\":\"any\"}")).isInstanceOf(JsonExtractException.class);
    }

    @Test
    void parseShouldThrowOnValidationProblemNPE() {
        Assertions.assertThatThrownBy(() -> this.jsonExtractor.parse("{\"field1\":null,\"field2\":\"any\"}")).isInstanceOf(JsonExtractException.class);
    }

    @Test
    void parseShouldThrowOnExtraFiled() {
        Assertions.assertThatThrownBy(() -> this.jsonExtractor.parse("{\"field1\":\"value\",\"field2\":\"any\",\"extra\":\"extra\"}")).isInstanceOf(JsonExtractException.class);
    }

    @Test
    void parseShouldInstantiateDestinationClass() throws Exception {
        String field1 = "value1";
        String field2 = "value2";
        Request request = (Request)this.jsonExtractor.parse("{\"field1\":\"" + field1 + "\",\"field2\":\"" + field2 + "\"}");
        Assertions.assertThat((String)request.getField1()).isEqualTo(field1);
        Assertions.assertThat((String)request.getField2()).isEqualTo(field2);
    }

    static class Request {
        private final String field1;
        private final String field2;

        @JsonCreator
        public Request(@JsonProperty(value="field1") String field1, @JsonProperty(value="field2") String field2) {
            Preconditions.checkNotNull((Object)field1);
            Preconditions.checkNotNull((Object)field2);
            Preconditions.checkArgument((!field1.isEmpty() ? 1 : 0) != 0);
            this.field1 = field1;
            this.field2 = field2;
        }

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }
    }
}

