/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.utils;

import java.util.Optional;
import org.apache.james.util.streams.Limit;
import org.apache.james.util.streams.Offset;
import org.apache.james.webadmin.utils.ParametersExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import spark.HaltException;
import spark.Request;

class ParametersExtractorTest {
    ParametersExtractorTest() {
    }

    @Test
    void extractLimitShouldReturnUnlimitedWhenNotInParameters() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("limit")).thenReturn(null);
        Limit limit = ParametersExtractor.extractLimit((Request)request);
        Assertions.assertThat((Object)limit).isEqualTo((Object)Limit.unlimited());
    }

    @Test
    void extractLimitShouldReturnUnlimitedWhenPresentInParametersButEmpty() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("limit")).thenReturn((Object)"");
        Limit limit = ParametersExtractor.extractLimit((Request)request);
        Assertions.assertThat((Object)limit).isEqualTo((Object)Limit.unlimited());
    }

    @Test
    void extractLimitShouldReturnTheLimitWhenPresentInParameters() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("limit")).thenReturn((Object)"123");
        Limit limit = ParametersExtractor.extractLimit((Request)request);
        Assertions.assertThat((Object)limit).isEqualTo((Object)Limit.from((int)123));
    }

    @Test
    void extractLimitShouldThrowWhenNegativeLimit() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("limit")).thenReturn((Object)"-123");
        Assertions.assertThatThrownBy(() -> ParametersExtractor.extractLimit((Request)request)).isInstanceOf(HaltException.class);
    }

    @Test
    void extractLimitShouldThrowWhenZeroLimit() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("limit")).thenReturn((Object)"0");
        Assertions.assertThatThrownBy(() -> ParametersExtractor.extractLimit((Request)request)).isInstanceOf(HaltException.class);
    }

    @Test
    void extractOffsetShouldReturnNoneWhenNotInParameters() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("offset")).thenReturn(null);
        Offset offset = ParametersExtractor.extractOffset((Request)request);
        Assertions.assertThat((Object)offset).isEqualTo((Object)Offset.none());
    }

    @Test
    void extractOffsetShouldReturnNoneWhenPresentInParametersButEmpty() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("offset")).thenReturn((Object)"");
        Offset offset = ParametersExtractor.extractOffset((Request)request);
        Assertions.assertThat((Object)offset).isEqualTo((Object)Offset.none());
    }

    @Test
    void extractOffsetShouldReturnTheOffsetWhenPresentInParameters() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("offset")).thenReturn((Object)"123");
        Offset offset = ParametersExtractor.extractOffset((Request)request);
        Assertions.assertThat((Object)offset).isEqualTo((Object)Offset.from((int)123));
    }

    @Test
    void extractOffsetShouldThrowWhenNegativeOffset() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("offset")).thenReturn((Object)"-123");
        Assertions.assertThatThrownBy(() -> ParametersExtractor.extractOffset((Request)request)).isInstanceOf(HaltException.class);
    }

    @Test
    void extractOffsetShouldReturnNoneWhenZeroLimit() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams("offset")).thenReturn((Object)"0");
        Offset offset = ParametersExtractor.extractOffset((Request)request);
        Assertions.assertThat((Object)offset).isEqualTo((Object)Offset.none());
    }

    @Test
    void extractPositiveDoubleShouldReturnEmptyWhenNotInParameters() {
        String parameterName = "param";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams(parameterName)).thenReturn(null);
        Optional result = ParametersExtractor.extractPositiveDouble((Request)request, (String)parameterName);
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @Test
    void extractPositiveDoubleShouldReturnNoneWhenPresentInParametersButEmpty() {
        String parameterName = "param";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams(parameterName)).thenReturn((Object)"");
        Optional result = ParametersExtractor.extractPositiveDouble((Request)request, (String)parameterName);
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @Test
    void extractPositiveDoubleShouldReturnTheDoubleWhenPresentInParameters() {
        String parameterName = "param";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams(parameterName)).thenReturn((Object)"123");
        Optional result = ParametersExtractor.extractPositiveDouble((Request)request, (String)parameterName);
        Assertions.assertThat((Optional)result).contains((Object)123.0);
    }

    @Test
    void extractPositiveDoubleShouldThrowWhenNegativePositiveDouble() {
        String parameterName = "param";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams(parameterName)).thenReturn((Object)"-123");
        Assertions.assertThatThrownBy(() -> ParametersExtractor.extractPositiveDouble((Request)request, (String)parameterName)).isInstanceOf(HaltException.class);
    }

    @Test
    void extractPositiveDoubleShouldReturnZeroWhenZeroLimit() {
        String parameterName = "param";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.queryParams(parameterName)).thenReturn((Object)"0");
        Optional result = ParametersExtractor.extractPositiveDouble((Request)request, (String)parameterName);
        Assertions.assertThat((Optional)result).contains((Object)0.0);
    }
}

