/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.ssl.PKCS8Key;
import org.apache.james.jdkim.DKIMSigner;
import org.apache.james.jdkim.api.BodyHasher;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.mailets.CRLFOutputStream;
import org.apache.james.jdkim.mailets.HeaderSkippingOutputStream;
import org.apache.james.jdkim.mailets.MimeMessageHeaders;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class DKIMSign
extends GenericMailet {
    private String signatureTemplate;
    private PrivateKey privateKey;
    private boolean forceCRLF;

    protected String getSignatureTemplate() {
        return this.signatureTemplate;
    }

    protected PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void init() throws MessagingException {
        this.signatureTemplate = this.getInitParameter("signatureTemplate");
        String privateKeyString = this.getInitParameter("privateKey");
        String privateKeyPassword = this.getInitParameter("privateKeyPassword", null);
        this.forceCRLF = this.getInitParameter("forceCRLF", true);
        try {
            PKCS8Key pkcs8 = new PKCS8Key(new ByteArrayInputStream(privateKeyString.getBytes()), privateKeyPassword != null ? privateKeyPassword.toCharArray() : null);
            this.privateKey = pkcs8.getPrivateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MessagingException("Unknown private key algorythm: " + e.getMessage(), (Exception)e);
        }
        catch (InvalidKeySpecException e) {
            throw new MessagingException("PrivateKey should be in base64 encoded PKCS8 (der) format: " + e.getMessage(), (Exception)e);
        }
        catch (GeneralSecurityException e) {
            throw new MessagingException("General security exception: " + e.getMessage(), (Exception)e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        DKIMSigner signer = new DKIMSigner(this.getSignatureTemplate(), this.getPrivateKey());
        SignatureRecord signRecord = signer.newSignatureRecordTemplate(this.getSignatureTemplate());
        try {
            BodyHasher bhj = signer.newBodyHasher(signRecord);
            MimeMessage message = mail.getMessage();
            MimeMessageHeaders headers = new MimeMessageHeaders(message);
            try {
                FilterOutputStream os = new HeaderSkippingOutputStream(bhj.getOutputStream());
                if (this.forceCRLF) {
                    os = new CRLFOutputStream(os);
                }
                message.writeTo((OutputStream)os);
                bhj.getOutputStream().close();
            }
            catch (IOException e) {
                throw new MessagingException("Exception calculating bodyhash: " + e.getMessage(), (Exception)e);
            }
            String signatureHeader = signer.sign((Headers)headers, bhj);
            this.prependHeader(message, signatureHeader);
        }
        catch (PermFailException e) {
            throw new MessagingException("PermFail while signing: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void prependHeader(MimeMessage message, String signatureHeader) throws MessagingException {
        LinkedList<String> prevHeader = new LinkedList<String>();
        Enumeration e = message.getAllHeaderLines();
        while (e.hasMoreElements()) {
            String string = (String)e.nextElement();
            prevHeader.add(string);
        }
        e = message.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            message.removeHeader(header.getName());
        }
        message.addHeaderLine(signatureHeader);
        for (String string : prevHeader) {
            message.addHeaderLine(string);
        }
    }
}

