/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.apache.johnzon.core.JsonArrayBuilderImpl;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonObjectBuilderImpl;
import org.apache.johnzon.core.JsonStringImpl;

class JsonReaderImpl
implements JsonReader {
    private final JsonParser parser;
    private boolean closed = false;

    JsonReaderImpl(JsonParser parser) {
        this.parser = parser;
    }

    public JsonStructure read() {
        this.checkClosed();
        if (!this.parser.hasNext()) {
            throw new IllegalStateException("Nothing to read");
        }
        switch (this.parser.next()) {
            case START_OBJECT: {
                JsonObjectBuilderImpl objectBuilder = new JsonObjectBuilderImpl();
                this.parseObject(objectBuilder);
                if (this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                this.close();
                return objectBuilder.build();
            }
            case START_ARRAY: {
                JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
                this.parseArray(arrayBuilder);
                if (this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                this.close();
                return arrayBuilder.build();
            }
        }
        this.close();
        throw new JsonParsingException("Unknown structure: " + this.parser.next(), this.parser.getLocation());
    }

    public JsonObject readObject() {
        return (JsonObject)JsonObject.class.cast(this.read());
    }

    public JsonArray readArray() {
        return (JsonArray)JsonArray.class.cast(this.read());
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.parser.close();
        }
    }

    private void parseObject(JsonObjectBuilder builder) {
        String key = null;
        block12: while (this.parser.hasNext()) {
            JsonParser.Event next = this.parser.next();
            switch (next) {
                case KEY_NAME: {
                    key = this.parser.getString();
                    continue block12;
                }
                case VALUE_STRING: {
                    builder.add(key, (JsonValue)new JsonStringImpl(this.parser.getString()));
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilderImpl subObject = null;
                    subObject = new JsonObjectBuilderImpl();
                    this.parseObject(subObject);
                    builder.add(key, (JsonObjectBuilder)subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilderImpl subArray = null;
                    subArray = new JsonArrayBuilderImpl();
                    this.parseArray(subArray);
                    builder.add(key, (JsonArrayBuilder)subArray);
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isIntegralNumber()) {
                        builder.add(key, (JsonValue)new JsonLongImpl(this.parser.getLong()));
                        continue block12;
                    }
                    builder.add(key, (JsonValue)new JsonNumberImpl(this.parser.getBigDecimal()));
                    continue block12;
                }
                case VALUE_NULL: {
                    builder.addNull(key);
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(key, true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(key, false);
                    continue block12;
                }
                case END_OBJECT: {
                    return;
                }
                case END_ARRAY: {
                    throw new JsonParsingException("']', shouldn't occur", this.parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", this.parser.getLocation());
        }
    }

    private void parseArray(JsonArrayBuilder builder) {
        block12: while (this.parser.hasNext()) {
            JsonParser.Event next = this.parser.next();
            switch (next) {
                case VALUE_STRING: {
                    builder.add((JsonValue)new JsonStringImpl(this.parser.getString()));
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isIntegralNumber()) {
                        builder.add((JsonValue)new JsonLongImpl(this.parser.getLong()));
                        continue block12;
                    }
                    builder.add((JsonValue)new JsonNumberImpl(this.parser.getBigDecimal()));
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilderImpl subObject = null;
                    subObject = new JsonObjectBuilderImpl();
                    this.parseObject(subObject);
                    builder.add((JsonObjectBuilder)subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilderImpl subArray = null;
                    subArray = new JsonArrayBuilderImpl();
                    this.parseArray(subArray);
                    builder.add((JsonArrayBuilder)subArray);
                    continue block12;
                }
                case END_ARRAY: {
                    return;
                }
                case VALUE_NULL: {
                    builder.addNull();
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(false);
                    continue block12;
                }
                case KEY_NAME: {
                    throw new JsonParsingException("array doesn't have keys", this.parser.getLocation());
                }
                case END_OBJECT: {
                    throw new JsonParsingException("'}', shouldn't occur", this.parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", this.parser.getLocation());
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("read(), readObject(), readArray() or close() method was already called");
        }
    }
}

