/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.identitybackend;

import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtil {
    public static final char ZNODE_PATH_SEPARATOR = '/';
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtil.class);

    public static String joinZNode(String prefix, String suffix) {
        return prefix + '/' + suffix;
    }

    public static int checkExists(ZooKeeper zk, String node) throws KeeperException {
        try {
            Stat s = zk.exists(node, null);
            return s != null ? s.getVersion() : -1;
        }
        catch (KeeperException e) {
            return -1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    public static boolean setData(ZooKeeper zk, String node, byte[] data) throws KeeperException {
        try {
            return zk.setData(node, data, -1) != null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static void createSetData(ZooKeeper zk, String node, byte[] data) throws KeeperException {
        if (ZKUtil.checkExists(zk, node) == -1) {
            ZKUtil.createWithParents(zk, node, data);
        } else {
            ZKUtil.setData(zk, node, data);
        }
    }

    public static void createWithParents(ZooKeeper zk, String node) throws KeeperException {
        ZKUtil.createWithParents(zk, node, new byte[0]);
    }

    public static void createWithParents(ZooKeeper zk, String node, byte[] data) throws KeeperException {
        try {
            if (node == null) {
                return;
            }
            zk.create(node, data, ZKUtil.createACL(zk, node), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            return;
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createWithParents(zk, ZKUtil.getParent(node));
            ZKUtil.createWithParents(zk, node, data);
        }
        catch (InterruptedException ie) {
            LOG.warn("Fail to create node: " + node, (Throwable)ie);
        }
    }

    private static ArrayList<ACL> createACL(ZooKeeper zk, String node) {
        return ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    public static String getParent(String node) {
        int idx = node.lastIndexOf(47);
        return idx <= 0 ? null : node.substring(0, idx);
    }

    public static byte[] getData(ZooKeeper zk, String node) throws KeeperException, InterruptedException {
        try {
            byte[] data = zk.getData(node, false, null);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug("Unable to get data of znode " + node + " because node does not exist");
            return null;
        }
        catch (KeeperException e) {
            LOG.warn("Unable to get data of znode " + node, (Throwable)e);
            return null;
        }
    }

    public static List<String> listChildrenNoWatch(ZooKeeper zk, String node) throws KeeperException {
        List children = null;
        try {
            children = zk.getChildren(node, null);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (InterruptedException ie) {
            LOG.warn("Fail to list children of node: " + node, (Throwable)ie);
        }
        return children;
    }

    public static void deleteNodeRecursively(ZooKeeper zk, String node) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(zk, node);
        if (children == null) {
            return;
        }
        if (!children.isEmpty()) {
            for (String child : children) {
                ZKUtil.deleteNodeRecursively(zk, ZKUtil.joinZNode(node, child));
            }
        }
        try {
            zk.delete(node, -1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

