/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.identitybackend;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kerby.config.Config;
import org.apache.kerby.config.ConfigKey;
import org.apache.kerby.kerberos.kdc.identitybackend.IdentityZNode;
import org.apache.kerby.kerberos.kdc.identitybackend.IdentityZNodeHelper;
import org.apache.kerby.kerberos.kdc.identitybackend.ZKConfKey;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import org.apache.kerby.kerberos.kerb.identity.backend.AbstractIdentityBackend;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperIdentityBackend
extends AbstractIdentityBackend {
    private static Thread zookeeperThread;
    private final ZooKeeperServerMain zooKeeperServer = new ZooKeeperServerMain();
    private String zkHost;
    private int zkPort;
    private File dataDir;
    private ZooKeeper zooKeeper;
    private static final Logger LOG;

    public ZookeeperIdentityBackend() {
    }

    public ZookeeperIdentityBackend(Config config) {
        this.setConfig(config);
    }

    protected void doInitialize() throws KrbException {
        LOG.info("Initializing the Zookeeper identity backend.");
        this.init();
    }

    protected void doStop() throws KrbException {
        try {
            this.zooKeeper.close();
        }
        catch (InterruptedException e) {
            LOG.error("Closing zookeeper interrupted." + e);
        }
        LOG.info("Zookeeper session closed.");
    }

    private void init() throws KrbException {
        this.zkHost = this.getConfig().getString((ConfigKey)ZKConfKey.ZK_HOST, true);
        this.zkPort = this.getConfig().getInt((ConfigKey)ZKConfKey.ZK_PORT, true);
        String dataDirString = this.getConfig().getString((ConfigKey)ZKConfKey.DATA_DIR, true);
        if (dataDirString == null || dataDirString.isEmpty()) {
            File zooKeeperDir = new File(this.getBackendConfig().getConfDir(), "zookeeper");
            this.dataDir = new File(zooKeeperDir, "data");
        } else {
            this.dataDir = new File(dataDirString);
        }
        if (!this.dataDir.exists() && !this.dataDir.mkdirs()) {
            throw new KrbException("could not create data file dir " + this.dataDir);
        }
        LOG.info("Data dir: " + this.dataDir);
        if (this.getConfig().getBoolean((ConfigKey)ZKConfKey.EMBEDDED_ZK, true).booleanValue()) {
            this.startEmbeddedZookeeper();
        }
        this.connectZK();
    }

    private void connectZK() throws KrbException {
        try {
            String serverStr = this.zkHost + ":" + this.zkPort;
            this.zooKeeper = new ZooKeeper(serverStr, 10000, (Watcher)new MyWatcher());
            while (!this.zooKeeper.getState().isConnected()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOG.error("Some thread has interrupted the current thread" + e);
                }
            }
            LOG.info("Success connect to zookeeper server.");
        }
        catch (IOException e) {
            LOG.error("Error occurred while connecting to zookeeper.");
            throw new KrbException("Failed to prepare Zookeeper connection");
        }
    }

    private void startEmbeddedZookeeper() throws KrbException {
        Properties startupProperties = new Properties();
        startupProperties.put("dataDir", this.dataDir.getAbsolutePath());
        startupProperties.put("clientPort", (Object)this.zkPort);
        QuorumPeerConfig quorumConfiguration = new QuorumPeerConfig();
        try {
            quorumConfiguration.parseProperties(startupProperties);
        }
        catch (Exception e) {
            throw new KrbException("Loading quorum configuraiton failed", (Throwable)e);
        }
        final ServerConfig configuration = new ServerConfig();
        configuration.readFrom(quorumConfiguration);
        if (zookeeperThread == null) {
            zookeeperThread = new Thread(){

                @Override
                public void run() {
                    try {
                        ZookeeperIdentityBackend.this.zooKeeperServer.runFromConfig(configuration);
                    }
                    catch (IOException e) {
                        LOG.warn(e.getMessage());
                    }
                }
            };
            zookeeperThread.setDaemon(true);
            zookeeperThread.start();
        }
        LOG.info("Embedded Zookeeper started.");
    }

    protected KrbIdentity doGetIdentity(String principalName) throws KrbException {
        principalName = this.replaceSlash(principalName);
        IdentityZNode identityZNode = new IdentityZNode(this.zooKeeper, principalName);
        KrbIdentity krb = new KrbIdentity(principalName);
        try {
            if (!identityZNode.exist()) {
                return null;
            }
            krb.setPrincipal(identityZNode.getPrincipalName());
            krb.setCreatedTime(identityZNode.getCreatedTime());
            krb.setDisabled(identityZNode.getDisabled());
            krb.setExpireTime(identityZNode.getExpireTime());
            krb.setKdcFlags(identityZNode.getKdcFlags());
            krb.addKeys(identityZNode.getKeys());
            krb.setKeyVersion(identityZNode.getKeyVersion());
            krb.setLocked(identityZNode.getLocked());
        }
        catch (KeeperException e) {
            throw new KrbException("Fail to get identity from zookeeper", (Throwable)e);
        }
        return krb;
    }

    protected KrbIdentity doAddIdentity(KrbIdentity identity) throws KrbException {
        try {
            this.setIdentity(identity);
        }
        catch (Exception e) {
            throw new KrbException("Fail to add identity to zookeeper", (Throwable)e);
        }
        return this.doGetIdentity(identity.getPrincipalName());
    }

    protected KrbIdentity doUpdateIdentity(KrbIdentity identity) throws KrbException {
        try {
            this.setIdentity(identity);
        }
        catch (Exception e) {
            throw new KrbException("Fail to update identity in zookeeper", (Throwable)e);
        }
        return this.doGetIdentity(identity.getPrincipalName());
    }

    protected void doDeleteIdentity(String principalName) throws KrbException {
        principalName = this.replaceSlash(principalName);
        IdentityZNode identityZNode = new IdentityZNode(this.zooKeeper, principalName);
        try {
            identityZNode.deleteIdentity();
        }
        catch (KeeperException e) {
            throw new KrbException("Fail to delete identity in zookeeper", (Throwable)e);
        }
    }

    protected Iterable<String> doGetIdentities() throws KrbException {
        List<String> identityNames;
        try {
            identityNames = IdentityZNodeHelper.getIdentityNames(this.zooKeeper);
        }
        catch (KeeperException e) {
            throw new KrbException("Fail to get identities from zookeeper", (Throwable)e);
        }
        if (identityNames == null || identityNames.isEmpty()) {
            return null;
        }
        ArrayList<String> newIdentities = new ArrayList<String>(identityNames.size());
        for (String name : identityNames) {
            if (name.contains("\\")) {
                name = name.replace("\\", "/");
            }
            newIdentities.add(name);
        }
        Collections.sort(newIdentities);
        return newIdentities;
    }

    private void setIdentity(KrbIdentity identity) throws KeeperException, IOException {
        String principalName = identity.getPrincipalName();
        principalName = this.replaceSlash(principalName);
        IdentityZNode identityZNode = new IdentityZNode(this.zooKeeper, principalName);
        identityZNode.setPrincipalName(identity.getPrincipalName());
        identityZNode.setCreatedTime(identity.getCreatedTime());
        identityZNode.setDisabled(identity.isDisabled());
        identityZNode.setExpireTime(identity.getExpireTime());
        identityZNode.setKdcFlags(identity.getKdcFlags());
        identityZNode.setKeys(identity.getKeys());
        identityZNode.setKeyVersion(identity.getKeyVersion());
        identityZNode.setLocked(identity.isLocked());
    }

    private String replaceSlash(String name) {
        if (name.contains("/")) {
            name = name.replace("/", "\\");
        }
        return name;
    }

    static {
        LOG = LoggerFactory.getLogger(ZookeeperIdentityBackend.class);
    }

    class MyWatcher
    implements Watcher {
        MyWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

