/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.tools;

import java.io.Serializable;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPartitioner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.spark.kudu.KuduContext;
import org.apache.kudu.spark.kudu.KuduReadOptions;
import org.apache.kudu.spark.kudu.KuduRelation;
import org.apache.kudu.spark.kudu.KuduTestSuite;
import org.apache.kudu.spark.kudu.SparkListenerUtil$;
import org.apache.kudu.spark.tools.DistributedDataGenerator$;
import org.apache.kudu.spark.tools.GeneratorMetrics;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.RandomUtils;
import org.apache.kudu.util.SchemaGenerator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a4AAD\b\u00015!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0003Y\u0003B\u0002\u001a\u0001A\u0003%A\u0006C\u00044\u0001\t\u0007I\u0011\u0002\u001b\t\rm\u0002\u0001\u0015!\u00036\u0011\u001da\u0004A1A\u0005\nuBa!\u0013\u0001!\u0002\u0013q\u0004\"\u0002&\u0001\t\u0003Y\u0005\"\u0002,\u0001\t\u0003Y\u0005\"\u0002-\u0001\t\u0003Y\u0005\"\u0002.\u0001\t\u0003Y\u0005\"\u0002/\u0001\t\u0003Y\u0005\"\u00020\u0001\t\u0003y&\u0001\b#jgR\u0014\u0018NY;uK\u0012$\u0015\r^1HK:,'/\u0019;peR+7\u000f\u001e\u0006\u0003!E\tQ\u0001^8pYNT!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012\u0001B6vIVT!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011c\u0001\u0001\u001cCA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"A\t\u0013\u000e\u0003\rR!\u0001F\t\n\u0005\u0015\u001a#!D&vIV$Vm\u001d;Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002\u001f\u0005\u0019An\\4\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R!aL\f\u0002\u000bMdg\r\u000e6\n\u0005Er#A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013!C4f]\u0016\u0014\u0018\r^8s+\u0005)\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0014\u0003\u0011)H/\u001b7\n\u0005i:$aD*dQ\u0016l\u0017mR3oKJ\fGo\u001c:\u0002\u0015\u001d,g.\u001a:bi>\u0014\b%A\bsC:$w.\u001c+bE2,g*Y7f+\u0005q\u0004CA G\u001d\t\u0001E\t\u0005\u0002B;5\t!I\u0003\u0002D3\u00051AH]8pizJ!!R\u000f\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bv\t\u0001C]1oI>lG+\u00192mK:\u000bW.\u001a\u0011\u0002-Q,7\u000f^$f]\u0016\u0014\u0018\r^3SC:$w.\u001c#bi\u0006$\u0012\u0001\u0014\t\u000395K!AT\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0011A\u0003\"!\u0015+\u000e\u0003IS!aU\f\u0002\u000b),h.\u001b;\n\u0005U\u0013&\u0001\u0002+fgR\f!\u0004^3ti\u001e+g.\u001a:bi\u0016\u001cV-];f]RL\u0017\r\u001c#bi\u0006D#!\u0003)\u0002'Q,7\u000f\u001e*fa\u0006\u0014H/\u001b;j_:$\u0015\r^1)\u0005)\u0001\u0016\u0001\u0004;fgRtU/\u001c+bg.\u001c\bFA\u0006Q\u0003]!Xm\u001d;Ok6$\u0016m]6t%\u0016\u0004\u0018M\u001d;ji&|g\u000e\u000b\u0002\r!\u0006\u0001\"/\u001e8HK:,'/\u0019;peR+7\u000f\u001e\u000b\u0003AN\u0004B\u0001H1dM&\u0011!-\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005%\"\u0017BA3\u0010\u0005A9UM\\3sCR|'/T3ue&\u001c7\u000fE\u0002hW6l\u0011\u0001\u001b\u0006\u0003S*\f1A\u001d3e\u0015\t\u0011R#\u0003\u0002mQ\n\u0019!\u000b\u0012#\u0011\u00059\fX\"A8\u000b\u0005AT\u0017aA:rY&\u0011!o\u001c\u0002\u0004%><\b\"\u0002;\u000e\u0001\u0004)\u0018\u0001B1sON\u00042\u0001\b<?\u0013\t9XDA\u0003BeJ\f\u0017\u0010")
public class DistributedDataGeneratorTest
implements KuduTestSuite {
    private final Logger log;
    private final SchemaGenerator generator;
    private final String randomTableName;
    private SparkSession ss;
    private KuduClient kuduClient;
    private KuduTable table;
    private KuduContext kuduContext;
    private final String tableName;
    private final String owner;
    private final String simpleTableName;
    private Schema schema;
    private Schema simpleSchema;
    private final CreateTableOptions tableOptions;
    private final String appID;
    private final SparkConf conf;
    private final KuduTestHarness harness;
    private volatile byte bitmap$0;

    @Before
    public void setUpBase() {
        KuduTestSuite.setUpBase$((KuduTestSuite)this);
    }

    @After
    public void tearDownBase() {
        KuduTestSuite.tearDownBase$((KuduTestSuite)this);
    }

    public void deleteRow(int key) {
        KuduTestSuite.deleteRow$((KuduTestSuite)this, (int)key);
    }

    public IndexedSeq<Tuple4<Object, Object, String, Object>> insertRows(KuduTable targetTable, int rowCount, int startIndex) {
        return KuduTestSuite.insertRows$((KuduTestSuite)this, (KuduTable)targetTable, (int)rowCount, (int)startIndex);
    }

    public int insertRows$default$3() {
        return KuduTestSuite.insertRows$default$3$((KuduTestSuite)this);
    }

    public long getLastPropagatedTimestampMs() {
        return KuduTestSuite.getLastPropagatedTimestampMs$((KuduTestSuite)this);
    }

    public IndexedSeq<Tuple4<Object, Object, String, Object>> upsertRowsWithRowDataSize(KuduTable targetTable, Integer rowCount, Integer rowDataSize) {
        return KuduTestSuite.upsertRowsWithRowDataSize$((KuduTestSuite)this, (KuduTable)targetTable, (Integer)rowCount, (Integer)rowDataSize);
    }

    public KuduRelation kuduRelationFromDataFrame(Dataset<Row> dataFrame) {
        return KuduTestSuite.kuduRelationFromDataFrame$((KuduTestSuite)this, dataFrame);
    }

    public SparkSession ss() {
        return this.ss;
    }

    public void ss_$eq(SparkSession x$1) {
        this.ss = x$1;
    }

    public KuduClient kuduClient() {
        return this.kuduClient;
    }

    public void kuduClient_$eq(KuduClient x$1) {
        this.kuduClient = x$1;
    }

    public KuduTable table() {
        return this.table;
    }

    public void table_$eq(KuduTable x$1) {
        this.table = x$1;
    }

    public KuduContext kuduContext() {
        return this.kuduContext;
    }

    public void kuduContext_$eq(KuduContext x$1) {
        this.kuduContext = x$1;
    }

    public String tableName() {
        return this.tableName;
    }

    public String owner() {
        return this.owner;
    }

    public String simpleTableName() {
        return this.simpleTableName;
    }

    private Schema schema$lzycompute() {
        DistributedDataGeneratorTest distributedDataGeneratorTest = this;
        synchronized (distributedDataGeneratorTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.schema = KuduTestSuite.schema$((KuduTestSuite)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.schema;
    }

    public Schema schema() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.schema$lzycompute() : this.schema;
    }

    private Schema simpleSchema$lzycompute() {
        DistributedDataGeneratorTest distributedDataGeneratorTest = this;
        synchronized (distributedDataGeneratorTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.simpleSchema = KuduTestSuite.simpleSchema$((KuduTestSuite)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.simpleSchema;
    }

    public Schema simpleSchema() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.simpleSchema$lzycompute() : this.simpleSchema;
    }

    public CreateTableOptions tableOptions() {
        return this.tableOptions;
    }

    public String appID() {
        return this.appID;
    }

    public SparkConf conf() {
        return this.conf;
    }

    @Rule
    public KuduTestHarness harness() {
        return this.harness;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$owner_$eq(String x$1) {
        this.owner = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$simpleTableName_$eq(String x$1) {
        this.simpleTableName = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$tableOptions_$eq(CreateTableOptions x$1) {
        this.tableOptions = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$appID_$eq(String x$1) {
        this.appID = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$harness_$eq(KuduTestHarness x$1) {
        this.harness = x$1;
    }

    public Logger log() {
        return this.log;
    }

    private SchemaGenerator generator() {
        return this.generator;
    }

    private String randomTableName() {
        return this.randomTableName;
    }

    @Test
    public void testGenerateRandomData() {
        int numRows = 100;
        String[] args = (String[])((Object[])new String[]{new StringBuilder(11).append("--num-rows=").append(numRows).toString(), "--num-tasks=10", "--type=random", this.randomTableName(), this.harness().getMasterAddressesAsString()});
        Tuple2<GeneratorMetrics, RDD<Row>> tuple2 = this.runGeneratorTest(args);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GeneratorMetrics metrics = (GeneratorMetrics)tuple2._1();
        RDD rdd = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metrics, (Object)rdd);
        Tuple2 tuple23 = tuple22;
        GeneratorMetrics metrics2 = (GeneratorMetrics)tuple23._1();
        RDD rdd2 = (RDD)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)metrics2.rowsWritten().value(), (Object)metrics2.collisions().value());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Long rowsWritten = (Long)tuple24._1();
        Long collisions = (Long)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)rowsWritten, (Object)collisions);
        Tuple2 tuple26 = tuple25;
        Long rowsWritten2 = (Long)tuple26._1();
        Long collisions2 = (Long)tuple26._2();
        Assert.assertEquals((Object)rowsWritten2, (Object)BoxesRunTime.boxToLong((long)((Row[])rdd2.collect()).length));
        Assert.assertEquals((long)numRows, (long)(Predef$.MODULE$.Long2long(rowsWritten2) + Predef$.MODULE$.Long2long(collisions2)));
    }

    @Test
    public void testGenerateSequentialData() {
        int numRows = 100;
        String[] args = (String[])((Object[])new String[]{new StringBuilder(11).append("--num-rows=").append(numRows).toString(), "--num-tasks=10", "--type=sequential", this.randomTableName(), this.harness().getMasterAddressesAsString()});
        Tuple2<GeneratorMetrics, RDD<Row>> tuple2 = this.runGeneratorTest(args);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GeneratorMetrics metrics = (GeneratorMetrics)tuple2._1();
        RDD rdd = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metrics, (Object)rdd);
        Tuple2 tuple23 = tuple22;
        GeneratorMetrics metrics2 = (GeneratorMetrics)tuple23._1();
        RDD rdd2 = (RDD)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)metrics2.rowsWritten().value(), (Object)metrics2.collisions().value());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Long rowsWritten = (Long)tuple24._1();
        Long collisions = (Long)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)rowsWritten, (Object)collisions);
        Tuple2 tuple26 = tuple25;
        Long rowsWritten2 = (Long)tuple26._1();
        Long collisions2 = (Long)tuple26._2();
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)numRows), (Object)rowsWritten2);
        Assert.assertEquals((long)numRows, (long)((Row[])rdd2.collect()).length);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)collisions2);
    }

    @Test
    public void testRepartitionData() {
        int numRows = 100;
        String[] args = (String[])((Object[])new String[]{new StringBuilder(11).append("--num-rows=").append(numRows).toString(), "--num-tasks=10", "--type=sequential", "--repartition=true", this.randomTableName(), this.harness().getMasterAddressesAsString()});
        Tuple2<GeneratorMetrics, RDD<Row>> tuple2 = this.runGeneratorTest(args);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GeneratorMetrics metrics = (GeneratorMetrics)tuple2._1();
        RDD rdd = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metrics, (Object)rdd);
        Tuple2 tuple23 = tuple22;
        GeneratorMetrics metrics2 = (GeneratorMetrics)tuple23._1();
        RDD rdd2 = (RDD)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)metrics2.rowsWritten().value(), (Object)metrics2.collisions().value());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Long rowsWritten = (Long)tuple24._1();
        Long collisions = (Long)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)rowsWritten, (Object)collisions);
        Tuple2 tuple26 = tuple25;
        Long rowsWritten2 = (Long)tuple26._1();
        Long collisions2 = (Long)tuple26._2();
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)numRows), (Object)rowsWritten2);
        Assert.assertEquals((long)numRows, (long)((Row[])rdd2.collect()).length);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)collisions2);
    }

    @Test
    public void testNumTasks() {
        int numTasks = 8;
        int numRows = 100;
        String[] args = (String[])((Object[])new String[]{new StringBuilder(11).append("--num-rows=").append(numRows).toString(), new StringBuilder(12).append("--num-tasks=").append(numTasks).toString(), this.randomTableName(), this.harness().getMasterAddressesAsString()});
        int actualNumTasks = SparkListenerUtil$.MODULE$.withJobTaskCounter(this.ss().sparkContext(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runGeneratorTest(args));
        Assert.assertEquals((long)numTasks, (long)actualNumTasks);
    }

    @Test
    public void testNumTasksRepartition() {
        int numTasks = 8;
        int numRows = 100;
        String[] args = (String[])((Object[])new String[]{new StringBuilder(11).append("--num-rows=").append(numRows).toString(), new StringBuilder(12).append("--num-tasks=").append(numTasks).toString(), "--repartition=true", this.randomTableName(), this.harness().getMasterAddressesAsString()});
        int actualNumTasks = SparkListenerUtil$.MODULE$.withJobTaskCounter(this.ss().sparkContext(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runGeneratorTest(args));
        KuduTable table = this.kuduContext().syncClient().openTable(this.randomTableName());
        int numPartitions = new KuduPartitioner.KuduPartitionerBuilder(table).build().numPartitions();
        Assert.assertEquals((long)(numTasks + numPartitions), (long)actualNumTasks);
    }

    public Tuple2<GeneratorMetrics, RDD<Row>> runGeneratorTest(String[] args) {
        Schema schema = this.generator().randomSchema();
        CreateTableOptions options = this.generator().randomCreateTableOptions(schema);
        this.kuduClient().createTable(this.randomTableName(), schema, options);
        GeneratorMetrics metrics = DistributedDataGenerator$.MODULE$.testMain(args, this.ss());
        KuduContext qual$1 = this.kuduContext();
        SparkContext x$1 = this.ss().sparkContext();
        String x$2 = this.randomTableName();
        Seq x$3 = qual$1.kuduRDD$default$3();
        KuduReadOptions x$4 = qual$1.kuduRDD$default$4();
        return new Tuple2((Object)metrics, (Object)qual$1.kuduRDD(x$1, x$2, x$3, x$4));
    }

    public DistributedDataGeneratorTest() {
        KuduTestSuite.$init$((KuduTestSuite)this);
        this.log = LoggerFactory.getLogger(this.getClass());
        this.generator = new SchemaGenerator.SchemaGeneratorBuilder().random(RandomUtils.getRandom()).excludeTypes(new Type[]{Type.BOOL, Type.INT8}).precisionRange(9, 38).build();
        this.randomTableName = "random-table";
    }
}

