/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.tools;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.spark.kudu.KuduContext;
import org.apache.kudu.spark.kudu.KuduReadOptions;
import org.apache.kudu.spark.kudu.KuduRelation;
import org.apache.kudu.spark.kudu.KuduTestSuite;
import org.apache.kudu.spark.tools.ImportExportFiles$;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4Aa\u0004\t\u00017!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003BB\u001b\u0001A\u0003%Q\u0006C\u00047\u0001\t\u0007I\u0011\u0002\u0017\t\r]\u0002\u0001\u0015!\u0003.\u0011\u001dA\u0004A1A\u0005\neBaA\u0010\u0001!\u0002\u0013Q\u0004bB \u0001\u0005\u0004%I\u0001\u0011\u0005\u0007\u000f\u0002\u0001\u000b\u0011B!\t\u000b!\u0003A\u0011A%\t\u000bQ\u0003A\u0011A%\t\u000be\u0003A\u0011A%\t\u000bm\u0003A\u0011\u0002/\t\u000b\u001d\u0004A\u0011\u00025\u0003+Q+7\u000f^%na>\u0014H/\u0012=q_J$h)\u001b7fg*\u0011\u0011CE\u0001\u0006i>|Gn\u001d\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\t-,H-\u001e\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G\u0015j\u0011\u0001\n\u0006\u0003+II!A\n\u0013\u0003\u001b-+H-\u001e+fgR\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t\u0001#A\u0007UC\ndW\rR1uCB\u000bG\u000f[\u000b\u0002[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005Y\u0006twMC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qz#AB*ue&tw-\u0001\bUC\ndW\rR1uCB\u000bG\u000f\u001b\u0011\u0002\u0013Q\u000b'\r\\3OC6,\u0017A\u0003+bE2,g*Y7fA\u0005YA+\u00192mKN\u001b\u0007.Z7b+\u0005Q\u0004CA\u001e=\u001b\u0005!\u0012BA\u001f\u0015\u0005\u0019\u00196\r[3nC\u0006aA+\u00192mKN\u001b\u0007.Z7bA\u00059q\u000e\u001d;j_:\u001cX#A!\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0012AB2mS\u0016tG/\u0003\u0002G\u0007\n\u00112I]3bi\u0016$\u0016M\u00197f\u001fB$\u0018n\u001c8t\u0003!y\u0007\u000f^5p]N\u0004\u0013!B:fiV\u0003H#\u0001&\u0011\u0005uY\u0015B\u0001'\u001f\u0005\u0011)f.\u001b;)\u0005)q\u0005CA(S\u001b\u0005\u0001&BA)\u0019\u0003\u0015QWO\\5u\u0013\t\u0019\u0006K\u0001\u0004CK\u001a|'/Z\u0001\u000ei\u0016\u001cHoQ*W\u00136\u0004xN\u001d;)\u0005-1\u0006CA(X\u0013\tA\u0006K\u0001\u0003UKN$\u0018A\u0004;fgR\u0014v.\u001e8e)JL\u0007o\u001d\u0015\u0003\u0019Y\u000ba\u0002\\8bIN\u000bW\u000e\u001d7f\t\u0006$\u0018\rF\u0002K;\nDQAX\u0007A\u0002}\u000bQ\u0001^1cY\u0016\u0004\"A\u00111\n\u0005\u0005\u001c%!C&vIV$\u0016M\u00197f\u0011\u0015\u0019W\u00021\u0001e\u0003\u001dqW/\u001c*poN\u0004\"!H3\n\u0005\u0019t\"aA%oi\u0006\u0001\"/\u001e8S_VtG\r\u0016:jaR+7\u000f\u001e\u000b\u0005\u0015&,x\u000fC\u0003k\u001d\u0001\u00071.A\u0005ge>lG+\u00192mKB\u0011An\u001d\b\u0003[F\u0004\"A\u001c\u0010\u000e\u0003=T!\u0001\u001d\u000e\u0002\rq\u0012xn\u001c;?\u0013\t\u0011h$\u0001\u0004Qe\u0016$WMZ\u0005\u0003iQT!A\u001d\u0010\t\u000bYt\u0001\u0019A6\u0002\u000fQ|G+\u00192mK\")\u0001P\u0004a\u0001W\u00061am\u001c:nCR\u0004")
public class TestImportExportFiles
implements KuduTestSuite {
    private final String TableDataPath;
    private final String TableName;
    private final Schema TableSchema;
    private final CreateTableOptions options;
    private SparkSession ss;
    private KuduClient kuduClient;
    private KuduTable table;
    private KuduContext kuduContext;
    private final String tableName;
    private final String owner;
    private final String simpleTableName;
    private Schema schema;
    private Schema simpleSchema;
    private final CreateTableOptions tableOptions;
    private final String appID;
    private final SparkConf conf;
    private final KuduTestHarness harness;
    private volatile byte bitmap$0;

    @Before
    public void setUpBase() {
        KuduTestSuite.setUpBase$((KuduTestSuite)this);
    }

    @After
    public void tearDownBase() {
        KuduTestSuite.tearDownBase$((KuduTestSuite)this);
    }

    public void deleteRow(int key) {
        KuduTestSuite.deleteRow$((KuduTestSuite)this, (int)key);
    }

    public IndexedSeq<Tuple4<Object, Object, String, Object>> insertRows(KuduTable targetTable, int rowCount, int startIndex) {
        return KuduTestSuite.insertRows$((KuduTestSuite)this, (KuduTable)targetTable, (int)rowCount, (int)startIndex);
    }

    public int insertRows$default$3() {
        return KuduTestSuite.insertRows$default$3$((KuduTestSuite)this);
    }

    public long getLastPropagatedTimestampMs() {
        return KuduTestSuite.getLastPropagatedTimestampMs$((KuduTestSuite)this);
    }

    public IndexedSeq<Tuple4<Object, Object, String, Object>> upsertRowsWithRowDataSize(KuduTable targetTable, Integer rowCount, Integer rowDataSize) {
        return KuduTestSuite.upsertRowsWithRowDataSize$((KuduTestSuite)this, (KuduTable)targetTable, (Integer)rowCount, (Integer)rowDataSize);
    }

    public KuduRelation kuduRelationFromDataFrame(Dataset<Row> dataFrame) {
        return KuduTestSuite.kuduRelationFromDataFrame$((KuduTestSuite)this, dataFrame);
    }

    public SparkSession ss() {
        return this.ss;
    }

    public void ss_$eq(SparkSession x$1) {
        this.ss = x$1;
    }

    public KuduClient kuduClient() {
        return this.kuduClient;
    }

    public void kuduClient_$eq(KuduClient x$1) {
        this.kuduClient = x$1;
    }

    public KuduTable table() {
        return this.table;
    }

    public void table_$eq(KuduTable x$1) {
        this.table = x$1;
    }

    public KuduContext kuduContext() {
        return this.kuduContext;
    }

    public void kuduContext_$eq(KuduContext x$1) {
        this.kuduContext = x$1;
    }

    public String tableName() {
        return this.tableName;
    }

    public String owner() {
        return this.owner;
    }

    public String simpleTableName() {
        return this.simpleTableName;
    }

    private Schema schema$lzycompute() {
        TestImportExportFiles testImportExportFiles = this;
        synchronized (testImportExportFiles) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.schema = KuduTestSuite.schema$((KuduTestSuite)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.schema;
    }

    public Schema schema() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.schema$lzycompute() : this.schema;
    }

    private Schema simpleSchema$lzycompute() {
        TestImportExportFiles testImportExportFiles = this;
        synchronized (testImportExportFiles) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.simpleSchema = KuduTestSuite.simpleSchema$((KuduTestSuite)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.simpleSchema;
    }

    public Schema simpleSchema() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.simpleSchema$lzycompute() : this.simpleSchema;
    }

    public CreateTableOptions tableOptions() {
        return this.tableOptions;
    }

    public String appID() {
        return this.appID;
    }

    public SparkConf conf() {
        return this.conf;
    }

    @Rule
    public KuduTestHarness harness() {
        return this.harness;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$owner_$eq(String x$1) {
        this.owner = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$simpleTableName_$eq(String x$1) {
        this.simpleTableName = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$tableOptions_$eq(CreateTableOptions x$1) {
        this.tableOptions = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$appID_$eq(String x$1) {
        this.appID = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$kudu$spark$kudu$KuduTestSuite$_setter_$harness_$eq(KuduTestHarness x$1) {
        this.harness = x$1;
    }

    private String TableDataPath() {
        return this.TableDataPath;
    }

    private String TableName() {
        return this.TableName;
    }

    private Schema TableSchema() {
        return this.TableSchema;
    }

    private CreateTableOptions options() {
        return this.options;
    }

    @Before
    public void setUp() {
        this.kuduClient().createTable(this.TableName(), this.TableSchema(), this.options());
    }

    @Test
    public void testCSVImport() {
        URL schemaResource = TestImportExportFiles.class.getResource(this.TableDataPath());
        Path dataPath = Paths.get(schemaResource.toURI()).toAbsolutePath();
        ImportExportFiles$.MODULE$.testMain((String[])((Object[])new String[]{"--operation=import", "--format=csv", new StringBuilder(15).append("--master-addrs=").append(this.harness().getMasterAddressesAsString()).toString(), new StringBuilder(7).append("--path=").append(dataPath).toString(), new StringBuilder(13).append("--table-name=").append(this.TableName()).toString(), "--delimiter=,", "--header=true", "--inferschema=true"}), this.ss());
        KuduContext qual$1 = this.kuduContext();
        SparkContext x$1 = this.ss().sparkContext();
        String x$2 = this.TableName();
        .colon.colon x$3 = new .colon.colon((Object)"key", (List)Nil$.MODULE$);
        KuduReadOptions x$4 = qual$1.kuduRDD$default$4();
        RDD rdd = qual$1.kuduRDD(x$1, x$2, (Seq)x$3, x$4);
        Predef$.MODULE$.assert(((Row[])rdd.collect()).length == 4);
        Assert.assertEquals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.collect())).mkString(","), (Object)"[1],[2],[3],[4]");
    }

    @Test
    public void testRoundTrips() {
        KuduTable table = this.kuduClient().openTable(this.TableName());
        this.loadSampleData(table, 50);
        this.runRoundTripTest(this.TableName(), new StringBuilder(5).append(this.TableName()).append("-avro").toString(), "avro");
        this.runRoundTripTest(this.TableName(), new StringBuilder(4).append(this.TableName()).append("-csv").toString(), "csv");
        this.runRoundTripTest(this.TableName(), new StringBuilder(8).append(this.TableName()).append("-parquet").toString(), "parquet");
    }

    private void loadSampleData(KuduTable table, int numRows) {
        KuduSession session = this.kuduClient().newSession();
        package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)i -> TestImportExportFiles.$anonfun$loadSampleData$1(table, session, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        session.close();
    }

    private void runRoundTripTest(String fromTable, String toTable, String format) {
        Path dir = Files.createTempDirectory("round-trip", new FileAttribute[0]);
        String path = new File(dir.toFile(), new StringBuilder(1).append(fromTable).append("-").append(format).toString()).getAbsolutePath();
        ImportExportFiles$.MODULE$.testMain((String[])((Object[])new String[]{"--operation=export", new StringBuilder(9).append("--format=").append(format).toString(), new StringBuilder(15).append("--master-addrs=").append(this.harness().getMasterAddressesAsString()).toString(), new StringBuilder(7).append("--path=").append(path).toString(), new StringBuilder(13).append("--table-name=").append(fromTable).toString(), "--header=true"}), this.ss());
        this.kuduClient().createTable(toTable, this.TableSchema(), this.options());
        ImportExportFiles$.MODULE$.testMain((String[])((Object[])new String[]{"--operation=import", new StringBuilder(9).append("--format=").append(format).toString(), new StringBuilder(15).append("--master-addrs=").append(this.harness().getMasterAddressesAsString()).toString(), new StringBuilder(7).append("--path=").append(path).toString(), new StringBuilder(13).append("--table-name=").append(toTable).toString(), "--header=true"}), this.ss());
        KuduContext qual$1 = this.kuduContext();
        SparkContext x$1 = this.ss().sparkContext();
        String x$2 = fromTable;
        .colon.colon x$3 = new .colon.colon((Object)"key", (List)Nil$.MODULE$);
        KuduReadOptions x$4 = qual$1.kuduRDD$default$4();
        RDD rdd1 = qual$1.kuduRDD(x$1, x$2, (Seq)x$3, x$4);
        KuduContext qual$2 = this.kuduContext();
        SparkContext x$5 = this.ss().sparkContext();
        String x$6 = toTable;
        .colon.colon x$7 = new .colon.colon((Object)"key", (List)Nil$.MODULE$);
        KuduReadOptions x$8 = qual$2.kuduRDD$default$4();
        RDD rdd2 = qual$2.kuduRDD(x$5, x$6, (Seq)x$7, x$8);
        Assert.assertEquals((long)rdd1.count(), (long)rdd2.count());
    }

    public static final /* synthetic */ OperationResponse $anonfun$loadSampleData$1(KuduTable table$1, KuduSession session$1, int i) {
        Insert insert = table$1.newInsert();
        PartialRow row = insert.getRow();
        row.addString(0, Integer.toString(i));
        row.addString(1, Integer.toString(i));
        row.addString(3, Integer.toString(i));
        row.addString(4, Integer.toString(i));
        return session$1.apply((Operation)insert);
    }

    public TestImportExportFiles() {
        KuduTestSuite.$init$((KuduTestSuite)this);
        this.TableDataPath = "/TestImportExportFiles.csv";
        this.TableName = "TestImportExportFiles";
        ImmutableList columns = ImmutableList.of((Object)new ColumnSchema.ColumnSchemaBuilder("key", Type.STRING).key(true).build(), (Object)new ColumnSchema.ColumnSchemaBuilder("column1_i", Type.STRING).build(), (Object)new ColumnSchema.ColumnSchemaBuilder("column2_d", Type.STRING).nullable(true).build(), (Object)new ColumnSchema.ColumnSchemaBuilder("column3_s", Type.STRING).build(), (Object)new ColumnSchema.ColumnSchemaBuilder("column4_b", Type.STRING).build());
        this.TableSchema = new Schema((java.util.List)columns);
        this.options = new CreateTableOptions().setRangePartitionColumns((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"key", (List)Nil$.MODULE$)).asJava()).setNumReplicas(1);
    }
}

