/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.utils;

import org.apache.linkis.orchestrator.domain.TreeNode;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorCodeSummary$;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorException;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.TaskResponse;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.plans.physical.PhysicalContext;
import org.apache.linkis.orchestrator.strategy.ExecTaskStatusInfo;
import org.apache.linkis.orchestrator.strategy.StatusInfoExecTask$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;

public final class TreeNodeUtil$ {
    public static final TreeNodeUtil$ MODULE$;

    static {
        new TreeNodeUtil$();
    }

    private void bloodCheck(ExecTask parentNode, ExecTask childNode) {
        if (parentNode == null || childNode == null) {
            throw new OrchestratorErrorException(OrchestratorErrorCodeSummary$.MODULE$.JOB_REQUEST_PARAM_ILLEGAL_ERROR_CODE(), "parameter is null, please check again");
        }
        ExecTask[] children = (ExecTask[])parentNode.getChildren();
        if (children != null && Predef$.MODULE$.refArrayOps((Object[])children).contains((Object)childNode)) {
            ExecTask[] parents = (ExecTask[])childNode.getParents();
            if (parents != null && Predef$.MODULE$.refArrayOps((Object[])parents).contains((Object)parentNode)) {
                return;
            }
            throw new OrchestratorErrorException(OrchestratorErrorCodeSummary$.MODULE$.JOB_REQUEST_PARAM_ILLEGAL_ERROR_CODE(), "the child node does not belong the parent node(\u8be5\u5b50\u8282\u70b9\u4e0d\u76f4\u63a5\u5c5e\u4e8e\u8be5\u7236\u8282\u70b9)");
        }
        throw new OrchestratorErrorException(OrchestratorErrorCodeSummary$.MODULE$.JOB_REQUEST_PARAM_ILLEGAL_ERROR_CODE(), "the parent node does not contain the child node(\u8be5\u7236\u8282\u70b9\u4e0d\u76f4\u63a5\u5305\u542b\u8be5\u5b50\u8282\u70b9)");
    }

    public void insertNode(ExecTask parentNode, ExecTask childNode, ExecTask insertNode) {
        this.bloodCheck(parentNode, childNode);
        this.pruningTreeNode(parentNode, childNode);
        this.relateParentWithChild(parentNode, insertNode);
        this.relateParentWithChild(insertNode, childNode);
    }

    public void pruningTreeNode(ExecTask parentNode, ExecTask childNode) {
        this.bloodCheck(parentNode, childNode);
        ExecTask[] children = (ExecTask[])parentNode.getChildren();
        ExecTask[] newChildren = (ExecTask[])Predef$.MODULE$.refArrayOps((Object[])children).filter((Function1)new Serializable(childNode){
            public static final long serialVersionUID = 0L;
            private final ExecTask childNode$1;

            public final boolean apply(ExecTask x$1) {
                ExecTask execTask = x$1;
                ExecTask execTask2 = this.childNode$1;
                return execTask != null ? !execTask.equals(execTask2) : execTask2 != null;
            }
            {
                this.childNode$1 = childNode$1;
            }
        });
        parentNode.withNewChildren((TreeNode[])newChildren);
        ExecTask[] parents = (ExecTask[])childNode.getParents();
        ExecTask[] newParents = (ExecTask[])Predef$.MODULE$.refArrayOps((Object[])parents).filter((Function1)new Serializable(parentNode){
            public static final long serialVersionUID = 0L;
            private final ExecTask parentNode$1;

            public final boolean apply(ExecTask x$2) {
                ExecTask execTask = x$2;
                ExecTask execTask2 = this.parentNode$1;
                return execTask != null ? !execTask.equals(execTask2) : execTask2 != null;
            }
            {
                this.parentNode$1 = parentNode$1;
            }
        });
        childNode.withNewParents((TreeNode[])newParents);
    }

    public void relateParentWithChild(ExecTask parentNode, ExecTask childNode) {
        if (parentNode != null && childNode != null) {
            ArrayBuffer buffer = new ArrayBuffer();
            ExecTask[] parents = (ExecTask[])childNode.getParents();
            buffer.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])parents));
            buffer.$plus$eq((Object)parentNode);
            childNode.withNewParents((TreeNode[])buffer.toArray(ClassTag$.MODULE$.apply(ExecTask.class)));
            ExecTask[] children = (ExecTask[])parentNode.getChildren();
            buffer.clear();
            buffer.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])children));
            buffer.$plus$eq((Object)childNode);
            parentNode.withNewChildren((TreeNode[])buffer.toArray(ClassTag$.MODULE$.apply(ExecTask.class)));
        }
    }

    public void deleteNode(ExecTask node) {
        if (node.getParents() != null) {
            Predef$.MODULE$.refArrayOps((Object[])node.getParents()).foreach((Function1)new Serializable(node){
                public static final long serialVersionUID = 0L;
                private final ExecTask node$1;

                public final void apply(ExecTask parent) {
                    TreeNodeUtil$.MODULE$.pruningTreeNode(parent, this.node$1);
                }
                {
                    this.node$1 = node$1;
                }
            });
        }
        if (node.getChildren() != null) {
            Predef$.MODULE$.refArrayOps((Object[])node.getChildren()).foreach((Function1)new Serializable(node){
                public static final long serialVersionUID = 0L;
                private final ExecTask node$1;

                public final void apply(ExecTask child) {
                    TreeNodeUtil$.MODULE$.pruningTreeNode(this.node$1, child);
                }
                {
                    this.node$1 = node$1;
                }
            });
        }
    }

    public void replaceNode(ExecTask currentNode, ExecTask newNode) {
        if (currentNode != null) {
            ExecTask[] children = (ExecTask[])((ExecTask[])currentNode.getChildren()).clone();
            ExecTask[] parents = (ExecTask[])((ExecTask[])currentNode.getParents()).clone();
            this.deleteNode(currentNode);
            Predef$.MODULE$.refArrayOps((Object[])children).foreach((Function1)new Serializable(newNode){
                public static final long serialVersionUID = 0L;
                private final ExecTask newNode$1;

                public final void apply(ExecTask child) {
                    TreeNodeUtil$.MODULE$.relateParentWithChild(this.newNode$1, child);
                }
                {
                    this.newNode$1 = newNode$1;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])parents).foreach((Function1)new Serializable(newNode){
                public static final long serialVersionUID = 0L;
                private final ExecTask newNode$1;

                public final void apply(ExecTask parent) {
                    TreeNodeUtil$.MODULE$.relateParentWithChild(parent, this.newNode$1);
                }
                {
                    this.newNode$1 = newNode$1;
                }
            });
        }
    }

    public void org$apache$linkis$orchestrator$computation$utils$TreeNodeUtil$$recursionSearch(ExecTask node, Map<String, ExecTaskStatusInfo> statusInfoMap, ArrayBuffer<ExecTask> failedTasks) {
        BoxedUnit boxedUnit;
        if (node == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            ExecTaskStatusInfo status = (ExecTaskStatusInfo)statusInfoMap.get((Object)node.getId()).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            if (status == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                TaskResponse taskResponse = status.taskResponse();
                Object object = taskResponse instanceof FailedTaskResponse ? failedTasks.$plus$eq((Object)node) : BoxedUnit.UNIT;
                boxedUnit = object;
            }
        }
        ExecTask[] children = (ExecTask[])node.getChildren();
        if (children != null) {
            Predef$.MODULE$.refArrayOps((Object[])children).foreach((Function1)new Serializable(statusInfoMap, failedTasks){
                public static final long serialVersionUID = 0L;
                private final Map statusInfoMap$1;
                private final ArrayBuffer failedTasks$1;

                public final void apply(ExecTask child) {
                    TreeNodeUtil$.MODULE$.org$apache$linkis$orchestrator$computation$utils$TreeNodeUtil$$recursionSearch(child, (Map<String, ExecTaskStatusInfo>)this.statusInfoMap$1, (ArrayBuffer<ExecTask>)this.failedTasks$1);
                }
                {
                    this.statusInfoMap$1 = statusInfoMap$1;
                    this.failedTasks$1 = failedTasks$1;
                }
            });
        }
    }

    public ExecTask[] getAllFailedTaskNode(ExecTask rootNode) {
        PhysicalContext context = rootNode.getPhysicalContext();
        HashMap statusInfoMap = context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY()) == null ? new HashMap() : (Map)context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY());
        ArrayBuffer failedTasks = new ArrayBuffer();
        this.org$apache$linkis$orchestrator$computation$utils$TreeNodeUtil$$recursionSearch(rootNode, (Map<String, ExecTaskStatusInfo>)statusInfoMap, (ArrayBuffer<ExecTask>)failedTasks);
        return (ExecTask[])failedTasks.toArray(ClassTag$.MODULE$.apply(ExecTask.class));
    }

    public TaskResponse getTaskResponse(ExecTask task) {
        TaskResponse taskResponse;
        PhysicalContext context = task.getPhysicalContext();
        if (context == null) {
            taskResponse = null;
        } else {
            HashMap statusInfoMap = context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY()) == null ? new HashMap() : (Map)context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY());
            ExecTaskStatusInfo taskStatusInfo = (ExecTaskStatusInfo)statusInfoMap.get((Object)task.getId()).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            taskResponse = taskStatusInfo == null ? null : taskStatusInfo.taskResponse();
        }
        return taskResponse;
    }

    public Option<ExecTaskStatusInfo> removeTaskResponse(ExecTask task) {
        None$ none$;
        PhysicalContext context = task.getPhysicalContext();
        if (context == null) {
            none$ = None$.MODULE$;
        } else {
            HashMap statusInfoMap = context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY()) == null ? new HashMap() : (Map)context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY());
            none$ = statusInfoMap.remove((Object)task.getId());
        }
        return none$;
    }

    private TreeNodeUtil$() {
        MODULE$ = this;
    }
}

