/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.restful;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceEnv;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.core.formdata.FormDataTransformerFactory;
import org.apache.linkis.datasourcemanager.core.formdata.MultiPartFormDataTransformer;
import org.apache.linkis.datasourcemanager.core.restful.RestfulApiHelper;
import org.apache.linkis.datasourcemanager.core.service.DataSourceInfoService;
import org.apache.linkis.datasourcemanager.core.service.DataSourceRelateService;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidator;
import org.apache.linkis.datasourcemanager.core.vo.DataSourceEnvVo;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.security.SecurityFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/data-source-manager"}, produces={"application/json"})
public class DataSourceAdminRestfulApi {
    @Autowired
    private DataSourceInfoService dataSourceInfoService;
    @Autowired
    private DataSourceRelateService dataSourceRelateService;
    @Autowired
    private ParameterValidator parameterValidator;
    @Autowired
    private Validator beanValidator;
    private MultiPartFormDataTransformer formDataTransformer;

    @PostConstruct
    public void initRestful() {
        this.formDataTransformer = FormDataTransformerFactory.buildCustom();
    }

    @RequestMapping(value={"/env/json"}, method={RequestMethod.POST})
    public Message insertJsonEnv(@RequestBody DataSourceEnv dataSourceEnv, HttpServletRequest req) throws ErrorException {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = SecurityFilter.getLoginUsername((HttpServletRequest)req);
            if (!RestfulApiHelper.isAdminUser(userName)) {
                return Message.error((String)("User '" + userName + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
            }
            Set result = this.beanValidator.validate((Object)dataSourceEnv, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            dataSourceEnv.setCreateUser(userName);
            this.insertDataSourceEnv(dataSourceEnv);
            return Message.ok().data("insertId", (Object)dataSourceEnv.getId());
        }, "Fail to insert data source environment[\u65b0\u589e\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25]");
    }

    @RequestMapping(value={"/env-list/all/type/{typeId}"}, method={RequestMethod.GET})
    public Message getAllEnvListByDataSourceType(@PathVariable(value="typeId") Long typeId) {
        return RestfulApiHelper.doAndResponse(() -> {
            List<DataSourceEnv> envList = this.dataSourceInfoService.listDataSourceEnvByType(typeId);
            return Message.ok().data("envList", envList);
        }, "Fail to get data source environment list[\u83b7\u53d6\u6570\u636e\u6e90\u73af\u5883\u6e05\u5355\u5931\u8d25]");
    }

    @RequestMapping(value={"/env/{envId}"}, method={RequestMethod.GET})
    public Message getEnvEntityById(@PathVariable(value="envId") Long envId) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSourceEnv dataSourceEnv = this.dataSourceInfoService.getDataSourceEnv(envId);
            return Message.ok().data("env", (Object)dataSourceEnv);
        }, "Fail to get data source environment[\u83b7\u53d6\u6570\u636e\u6e90\u73af\u5883\u4fe1\u606f\u5931\u8d25]");
    }

    @RequestMapping(value={"/env/{envId}"}, method={RequestMethod.DELETE})
    public Message removeEnvEntity(@PathVariable(value="envId") Long envId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = SecurityFilter.getLoginUsername((HttpServletRequest)request);
            if (!RestfulApiHelper.isAdminUser(userName)) {
                return Message.error((String)("User '" + userName + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
            }
            Long removeId = this.dataSourceInfoService.removeDataSourceEnv(envId);
            if (removeId < 0L) {
                return Message.error((String)("Fail to remove data source environment[\u5220\u9664\u6570\u636e\u6e90\u73af\u5883\u4fe1\u606f\u5931\u8d25], [id:" + envId + "]"));
            }
            return Message.ok().data("removeId", (Object)removeId);
        }, "Fail to remove data source environment[\u5220\u9664\u6570\u636e\u6e90\u73af\u5883\u4fe1\u606f\u5931\u8d25]");
    }

    @RequestMapping(value={"/env/{envId}/json"}, method={RequestMethod.PUT})
    public Message updateJsonEnv(@RequestBody DataSourceEnv dataSourceEnv, @PathVariable(value="envId") Long envId, HttpServletRequest request) throws ErrorException {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = SecurityFilter.getLoginUsername((HttpServletRequest)request);
            if (!RestfulApiHelper.isAdminUser(userName)) {
                return Message.error((String)("User '" + userName + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
            }
            Set result = this.beanValidator.validate((Object)dataSourceEnv, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            dataSourceEnv.setId(envId);
            dataSourceEnv.setModifyUser(userName);
            dataSourceEnv.setModifyTime(Calendar.getInstance().getTime());
            DataSourceEnv storedDataSourceEnv = this.dataSourceInfoService.getDataSourceEnv(envId);
            if (null == storedDataSourceEnv) {
                return Message.error((String)("Fail to update data source environment[\u66f4\u65b0\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25], [Please check the id:'" + envId + " is correct ']"));
            }
            dataSourceEnv.setCreateUser(storedDataSourceEnv.getCreateUser());
            this.updateDataSourceEnv(dataSourceEnv, storedDataSourceEnv);
            return Message.ok().data("updateId", (Object)envId);
        }, "Fail to update data source environment[\u66f4\u65b0\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25]");
    }

    @RequestMapping(value={"/env"}, method={RequestMethod.GET})
    public Message queryDataSourceEnv(@RequestParam(value="name", required=false) String envName, @RequestParam(value="typeId", required=false) Long dataSourceTypeId, @RequestParam(value="currentPage", required=false) Integer currentPage, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSourceEnvVo dataSourceEnvVo = new DataSourceEnvVo(envName, dataSourceTypeId);
            dataSourceEnvVo.setCurrentPage(null != currentPage ? currentPage : 1);
            dataSourceEnvVo.setPageSize(null != pageSize ? pageSize : 10);
            List<DataSourceEnv> queryList = this.dataSourceInfoService.queryDataSourceEnvPage(dataSourceEnvVo);
            return Message.ok().data("queryList", queryList);
        }, "Fail to query page of data source environment[\u67e5\u8be2\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25]");
    }

    private void insertDataSourceEnv(DataSourceEnv dataSourceEnv) throws ErrorException {
        List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSourceEnv.getDataSourceTypeId(), DataSourceParamKeyDefinition.Scope.ENV);
        dataSourceEnv.setKeyDefinitions(keyDefinitionList);
        Map connectParams = dataSourceEnv.getConnectParams();
        this.parameterValidator.validate(keyDefinitionList, connectParams);
        this.dataSourceInfoService.saveDataSourceEnv(dataSourceEnv);
    }

    private void updateDataSourceEnv(DataSourceEnv updatedOne, DataSourceEnv storedOne) throws ErrorException {
        List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(updatedOne.getDataSourceTypeId(), DataSourceParamKeyDefinition.Scope.ENV);
        updatedOne.setKeyDefinitions(keyDefinitionList);
        Map connectParams = updatedOne.getConnectParams();
        this.parameterValidator.validate(keyDefinitionList, connectParams);
        this.dataSourceInfoService.updateDataSourceEnv(updatedOne, storedOne);
    }
}

