/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.restful;

import com.github.pagehelper.PageInfo;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.ServiceErrorCode;
import org.apache.linkis.datasourcemanager.common.auth.AuthContext;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceType;
import org.apache.linkis.datasourcemanager.common.domain.DatasourceVersion;
import org.apache.linkis.datasourcemanager.core.formdata.FormDataTransformerFactory;
import org.apache.linkis.datasourcemanager.core.formdata.MultiPartFormDataTransformer;
import org.apache.linkis.datasourcemanager.core.restful.RestfulApiHelper;
import org.apache.linkis.datasourcemanager.core.service.DataSourceInfoService;
import org.apache.linkis.datasourcemanager.core.service.DataSourceRelateService;
import org.apache.linkis.datasourcemanager.core.service.MetadataOperateService;
import org.apache.linkis.datasourcemanager.core.service.hooks.DataSourceParamsHook;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidator;
import org.apache.linkis.datasourcemanager.core.vo.DataSourceVo;
import org.apache.linkis.metadatamanager.common.MdmConfiguration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.security.SecurityFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/data-source-manager"}, produces={"application/json"})
public class DataSourceCoreRestfulApi {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceCoreRestfulApi.class);
    @Autowired
    private DataSourceInfoService dataSourceInfoService;
    @Autowired
    private DataSourceRelateService dataSourceRelateService;
    @Autowired
    private ParameterValidator parameterValidator;
    @Autowired
    private Validator beanValidator;
    @Autowired
    private MetadataOperateService metadataOperateService;
    private MultiPartFormDataTransformer formDataTransformer;
    @Autowired
    private List<DataSourceParamsHook> dataSourceParamsHooks = new ArrayList<DataSourceParamsHook>();

    @PostConstruct
    public void initRestful() {
        this.formDataTransformer = FormDataTransformerFactory.buildCustom();
    }

    @RequestMapping(value={"/type/all"}, method={RequestMethod.GET})
    public Message getAllDataSourceTypes() {
        return RestfulApiHelper.doAndResponse(() -> {
            List<DataSourceType> dataSourceTypes = this.dataSourceRelateService.getAllDataSourceTypes();
            return Message.ok().data("typeList", dataSourceTypes);
        }, "Fail to get all types of data source[\u83b7\u53d6\u6570\u636e\u6e90\u7c7b\u578b\u5217\u8868\u5931\u8d25]");
    }

    @RequestMapping(value={"/key-define/type/{typeId}"}, method={RequestMethod.GET})
    public Message getKeyDefinitionsByType(@PathVariable(value="typeId") Long dataSourceTypeId) {
        return RestfulApiHelper.doAndResponse(() -> {
            List<DataSourceParamKeyDefinition> keyDefinitions = this.dataSourceRelateService.getKeyDefinitionsByType(dataSourceTypeId);
            return Message.ok().data("keyDefine", keyDefinitions);
        }, "Fail to get key definitions of data source type[\u67e5\u8be2\u6570\u636e\u6e90\u53c2\u6570\u952e\u503c\u5bf9\u5931\u8d25]");
    }

    @RequestMapping(value={"/info/json"}, method={RequestMethod.POST})
    public Message insertJsonInfo(@RequestBody DataSource dataSource, HttpServletRequest req) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = SecurityFilter.getLoginUsername((HttpServletRequest)req);
            Set result = this.beanValidator.validate((Object)dataSource, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            dataSource.setCreateUser(userName);
            if (this.dataSourceInfoService.existDataSource(dataSource.getDataSourceName())) {
                return Message.error((String)("The data source named: " + dataSource.getDataSourceName() + " has been existed [\u6570\u636e\u6e90: " + dataSource.getDataSourceName() + " \u5df2\u7ecf\u5b58\u5728]"));
            }
            this.insertDataSource(dataSource);
            return Message.ok().data("insertId", (Object)dataSource.getId());
        }, "Fail to insert data source[\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @RequestMapping(value={"/info/{dataSourceId}/json"}, method={RequestMethod.PUT})
    public Message updateDataSourceInJson(@RequestBody DataSource dataSource, @PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest req) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = SecurityFilter.getLoginUsername((HttpServletRequest)req);
            Set result = this.beanValidator.validate((Object)dataSource, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            dataSource.setId(dataSourceId);
            dataSource.setModifyUser(userName);
            dataSource.setModifyTime(Calendar.getInstance().getTime());
            DataSource storedDataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (null == storedDataSource) {
                return Message.error((String)"This data source was not found [\u66f4\u65b0\u6570\u636e\u6e90\u5931\u8d25]");
            }
            if (!AuthContext.hasPermission((DataSource)storedDataSource, (String)userName)) {
                return Message.error((String)"Don't have update permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u66f4\u65b0\u6743\u9650]");
            }
            String dataSourceName = dataSource.getDataSourceName();
            if (!Objects.equals(dataSourceName, storedDataSource.getDataSourceName()) && this.dataSourceInfoService.existDataSource(dataSourceName)) {
                return Message.error((String)("The data source named: " + dataSourceName + " has been existed [\u6570\u636e\u6e90: " + dataSourceName + " \u5df2\u7ecf\u5b58\u5728]"));
            }
            this.dataSourceInfoService.updateDataSourceInfo(dataSource);
            return Message.ok().data("updateId", (Object)dataSourceId);
        }, "Fail to update data source[\u66f4\u65b0\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @RequestMapping(value={"/parameter/{dataSourceId}/json"}, method={RequestMethod.POST})
    public Message insertJsonParameter(@PathVariable(value="dataSourceId") Long dataSourceId, @RequestBody Map<String, Object> params, HttpServletRequest req) {
        return RestfulApiHelper.doAndResponse(() -> {
            Map connectParams = (Map)params.get("connectParams");
            String comment = params.get("comment").toString();
            String userName = SecurityFilter.getLoginUsername((HttpServletRequest)req);
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (null == dataSource) {
                throw new ErrorException(((Integer)ServiceErrorCode.DATASOURCE_NOTFOUND_ERROR.getValue()).intValue(), "datasource not found ");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have update permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u66f4\u65b0\u6743\u9650]");
            }
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            this.parameterValidator.validate(keyDefinitionList, connectParams);
            RestfulApiHelper.encryptPasswordKey(keyDefinitionList, connectParams);
            long versionId = this.dataSourceInfoService.insertDataSourceParameter(keyDefinitionList, dataSourceId, connectParams, userName, comment);
            return Message.ok().data("version", (Object)versionId);
        }, "Fail to insert data source parameter [\u4fdd\u5b58\u6570\u636e\u6e90\u53c2\u6570\u5931\u8d25]");
    }

    @RequestMapping(value={"/info/{dataSourceId}"}, method={RequestMethod.GET})
    public Message getInfoByDataSourceId(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfo(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)request)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            RestfulApiHelper.decryptPasswordKey(this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId()), dataSource.getConnectParams());
            return Message.ok().data("info", (Object)dataSource);
        }, "Fail to access data source[\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @RequestMapping(value={"/info/name/{dataSourceName}"}, method={RequestMethod.GET})
    public Message getInfoByDataSourceName(@PathVariable(value="dataSourceName") String dataSourceName, HttpServletRequest request) throws UnsupportedEncodingException {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfo(dataSourceName);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)request)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            RestfulApiHelper.decryptPasswordKey(this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId()), dataSource.getConnectParams());
            return Message.ok().data("info", (Object)dataSource);
        }, "Fail to access data source[\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @RequestMapping(value={"/info/{dataSourceId}/{version}"}, method={RequestMethod.GET})
    public Message getInfoByDataSourceIdAndVersion(@PathVariable(value="dataSourceId") Long dataSourceId, @PathVariable(value="version") Long version, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfo(dataSourceId, version);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)request)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            RestfulApiHelper.decryptPasswordKey(this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId()), dataSource.getConnectParams());
            return Message.ok().data("info", (Object)dataSource);
        }, "Fail to access data source[\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @RequestMapping(value={"/{dataSourceId}/versions"}, method={RequestMethod.GET})
    public Message getVersionList(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)request)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            List<DatasourceVersion> versions = this.dataSourceInfoService.getVersionList(dataSourceId);
            if (null != versions) {
                versions.forEach(version -> RestfulApiHelper.decryptPasswordKey(this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId()), version.getConnectParams()));
            }
            return Message.ok().data("versions", versions);
        }, "Fail to access data source[\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @RequestMapping(value={"/publish/{dataSourceId}/{versionId}"}, method={RequestMethod.POST})
    public Message publishByDataSourceId(@PathVariable(value="dataSourceId") Long dataSourceId, @PathVariable(value="versionId") Long versionId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)request)) {
                return Message.error((String)"Don't have publish permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u53d1\u5e03\u6743\u9650]");
            }
            int updateResult = this.dataSourceInfoService.publishByDataSourceId(dataSourceId, versionId);
            if (0 == updateResult) {
                return Message.error((String)"publish error");
            }
            return Message.ok();
        }, "Fail to publish datasource[\u6570\u636e\u6e90\u7248\u672c\u53d1\u5e03\u5931\u8d25]");
    }

    @RequestMapping(value={"/info/delete/{dataSourceId}"}, method={RequestMethod.DELETE})
    public Message removeDataSource(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)request)) {
                return Message.error((String)"Don't have delete permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u5220\u9664\u6743\u9650]");
            }
            Long removeId = this.dataSourceInfoService.removeDataSourceInfo(dataSourceId, "");
            if (removeId < 0L) {
                return Message.error((String)("Fail to remove data source[\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25], [id:" + dataSourceId + "]"));
            }
            return Message.ok().data("removeId", (Object)removeId);
        }, "Fail to remove data source[\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @RequestMapping(value={"/info/{dataSourceId}/expire"}, method={RequestMethod.PUT})
    public Message expireDataSource(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)request)) {
                return Message.error((String)"Don't have operation permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u64cd\u4f5c\u6743\u9650]");
            }
            Long expireId = this.dataSourceInfoService.expireDataSource(dataSourceId);
            if (expireId < 0L) {
                return Message.error((String)("Fail to expire data source[\u6570\u636e\u6e90\u8fc7\u671f\u5931\u8d25], [id:" + dataSourceId + "]"));
            }
            return Message.ok().data("expireId", (Object)expireId);
        }, "Fail to expire data source[\u6570\u636e\u6e90\u8fc7\u671f\u5931\u8d25]");
    }

    @RequestMapping(value={"/{dataSourceId}/connect-params"}, method={RequestMethod.GET})
    public Message getConnectParams(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest req) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoForConnect(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)req)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            Map connectParams = dataSource.getConnectParams();
            RestfulApiHelper.decryptPasswordKey(this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId()), connectParams);
            return Message.ok().data("connectParams", (Object)connectParams);
        }, "Fail to connect data source[\u8fde\u63a5\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @RequestMapping(value={"/name/{dataSourceName}/connect-params"}, method={RequestMethod.GET})
    public Message getConnectParams(@PathVariable(value="dataSourceName") String dataSourceName, HttpServletRequest req) throws UnsupportedEncodingException {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoForConnect(dataSourceName);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)req)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            Map connectParams = dataSource.getConnectParams();
            RestfulApiHelper.decryptPasswordKey(this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId()), connectParams);
            return Message.ok().data("connectParams", (Object)connectParams);
        }, "Fail to connect data source[\u8fde\u63a5\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @RequestMapping(value={"/{dataSourceId}/{version}/op/connect"}, method={RequestMethod.PUT})
    public Message connectDataSource(@PathVariable(value="dataSourceId") Long dataSourceId, @PathVariable(value="version") Long version, HttpServletRequest req) {
        return RestfulApiHelper.doAndResponse(() -> {
            String operator = SecurityFilter.getLoginUsername((HttpServletRequest)req);
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoForConnect(dataSourceId, version);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (HttpServletRequest)req)) {
                return Message.error((String)"Don't have operation permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u64cd\u4f5c\u6743\u9650]");
            }
            String dataSourceTypeName = dataSource.getDataSourceType().getName();
            String mdRemoteServiceName = (String)MdmConfiguration.METADATA_SERVICE_APPLICATION.getValue();
            Map connectParams = dataSource.getConnectParams();
            RestfulApiHelper.decryptPasswordKey(this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId()), connectParams);
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            for (DataSourceParamsHook hook : this.dataSourceParamsHooks) {
                hook.beforePersist(connectParams, keyDefinitionList);
            }
            this.metadataOperateService.doRemoteConnect(mdRemoteServiceName, dataSourceTypeName.toLowerCase(), operator, dataSource.getConnectParams());
            return Message.ok().data("ok", (Object)true);
        }, "Fail to connect data source[\u8fde\u63a5\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public Message queryDataSource(@RequestParam(value="system", required=false) String createSystem, @RequestParam(value="name", required=false) String dataSourceName, @RequestParam(value="typeId", required=false) Long dataSourceTypeId, @RequestParam(value="identifies", required=false) String identifies, @RequestParam(value="currentPage", required=false) Integer currentPage, @RequestParam(value="pageSize", required=false) Integer pageSize, HttpServletRequest req) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSourceVo dataSourceVo = new DataSourceVo(dataSourceName, dataSourceTypeId, identifies, createSystem);
            dataSourceVo.setCurrentPage(null != currentPage ? currentPage : 1);
            dataSourceVo.setPageSize(null != pageSize ? pageSize : 10);
            String permissionUser = SecurityFilter.getLoginUsername((HttpServletRequest)req);
            if (AuthContext.isAdministrator((String)permissionUser)) {
                permissionUser = null;
            }
            dataSourceVo.setPermissionUser(permissionUser);
            PageInfo<DataSource> pageInfo = this.dataSourceInfoService.queryDataSourceInfoPage(dataSourceVo);
            List queryList = pageInfo.getList();
            return Message.ok().data("queryList", (Object)queryList).data("totalPage", (Object)pageInfo.getTotal());
        }, "Fail to query page of data source[\u67e5\u8be2\u6570\u636e\u6e90\u5931\u8d25]");
    }

    private void insertDataSource(DataSource dataSource) throws ErrorException {
        List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
        dataSource.setKeyDefinitions(keyDefinitionList);
        this.dataSourceInfoService.saveDataSourceInfo(dataSource);
    }
}

