/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.restful;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.apache.linkis.common.exception.WarnException;
import org.apache.linkis.datasourcemanager.common.auth.AuthContext;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.util.CryptoUtils;
import org.apache.linkis.datasourcemanager.core.restful.exception.BeanValidationExceptionMapper;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidateException;
import org.apache.linkis.server.Message;

public class RestfulApiHelper {
    public static boolean isAdminUser(String userName) {
        List<String> userList = Arrays.asList(((String)AuthContext.AUTH_ADMINISTRATOR.getValue()).split(","));
        return userList.contains(userName);
    }

    public static void encryptPasswordKey(List<DataSourceParamKeyDefinition> keyDefinitionList, Map<String, Object> connectParams) {
        keyDefinitionList.forEach(keyDefinition -> {
            Object password;
            if (keyDefinition.getValueType() == DataSourceParamKeyDefinition.ValueType.PASSWORD && null != (password = connectParams.get(keyDefinition.getKey()))) {
                connectParams.put(keyDefinition.getKey(), CryptoUtils.object2String((Serializable)((Object)String.valueOf(password))));
            }
        });
    }

    public static void decryptPasswordKey(List<DataSourceParamKeyDefinition> keyDefinitionList, Map<String, Object> connectParams) {
        keyDefinitionList.forEach(keyDefinition -> {
            Object password;
            if (keyDefinition.getValueType() == DataSourceParamKeyDefinition.ValueType.PASSWORD && null != (password = connectParams.get(keyDefinition.getKey()))) {
                connectParams.put(keyDefinition.getKey(), CryptoUtils.string2Object((String)String.valueOf(password)));
            }
        });
    }

    public static Message doAndResponse(TryOperation tryOperation, String failMessage) {
        try {
            Message message = tryOperation.operateAndGetMessage();
            return message;
        }
        catch (ParameterValidateException e) {
            return Message.error((String)e.getMessage());
        }
        catch (ConstraintViolationException e) {
            return new BeanValidationExceptionMapper().toResponse((ValidationException)e);
        }
        catch (WarnException e) {
            return Message.warn((String)e.getMessage());
        }
        catch (Exception e) {
            return Message.error((String)failMessage, (Throwable)e);
        }
    }

    private static Message setMethod(Message message, String method) {
        message.setMethod(method);
        return message;
    }

    @FunctionalInterface
    public static interface TryOperation {
        public Message operateAndGetMessage() throws Exception;
    }
}

