/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.service.impl;

import java.util.List;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceType;
import org.apache.linkis.datasourcemanager.core.dao.DataSourceParamKeyDao;
import org.apache.linkis.datasourcemanager.core.dao.DataSourceTypeDao;
import org.apache.linkis.datasourcemanager.core.service.DataSourceRelateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSourceRelateServiceImpl
implements DataSourceRelateService {
    @Autowired
    private DataSourceParamKeyDao paramKeyDao;
    @Autowired
    private DataSourceTypeDao dataSourceTypeDao;

    @Override
    public List<DataSourceParamKeyDefinition> getKeyDefinitionsByType(Long dataSourceTypeId, DataSourceParamKeyDefinition.Scope scope) {
        return this.paramKeyDao.listByDataSourceTypeAndScope(dataSourceTypeId, scope);
    }

    @Override
    public List<DataSourceParamKeyDefinition> getKeyDefinitionsByType(Long dataSourceTypeId) {
        return this.paramKeyDao.listByDataSourceType(dataSourceTypeId);
    }

    @Override
    public List<DataSourceType> getAllDataSourceTypes() {
        return this.dataSourceTypeDao.getAllTypes();
    }

    @Override
    public DataSourceType getDataSourceType(Long typeId) {
        return this.dataSourceTypeDao.selectOne(typeId);
    }
}

