/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.exception.WarnException;
import org.apache.linkis.datasourcemanager.common.ServiceErrorCode;
import org.apache.linkis.datasourcemanager.core.formdata.FormStreamContent;
import org.apache.linkis.datasourcemanager.core.service.BmlAppService;
import org.apache.linkis.datasourcemanager.core.service.MetadataOperateService;
import org.apache.linkis.metadatamanager.common.protocol.MetadataConnect;
import org.apache.linkis.metadatamanager.common.protocol.MetadataResponse;
import org.apache.linkis.rpc.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetadataOperateServiceImpl
implements MetadataOperateService {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataOperateService.class);
    @Autowired
    private BmlAppService bmlAppService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRemoteConnect(String mdRemoteServiceName, String dataSourceType, String operator, Map<String, Object> connectParams) throws WarnException {
        block9: {
            ArrayList uploadedResources = new ArrayList();
            try {
                connectParams.entrySet().removeIf(entry -> {
                    Object paramValue = entry.getValue();
                    if (paramValue instanceof FormStreamContent) {
                        FormStreamContent streamContent = (FormStreamContent)paramValue;
                        String fileName = streamContent.getFileName();
                        InputStream inputStream = streamContent.getStream();
                        if (null != inputStream) {
                            try {
                                String resourceId = this.bmlAppService.clientUploadResource(operator, fileName, inputStream);
                                if (null == resourceId) {
                                    return true;
                                }
                                uploadedResources.add(resourceId);
                                entry.setValue(resourceId);
                            }
                            catch (ErrorException e) {
                                throw new WarnException(((Integer)ServiceErrorCode.BML_SERVICE_ERROR.getValue()).intValue(), "Fail to operate file in request[\u4e0a\u4f20\u6587\u4ef6\u5904\u7406\u5931\u8d25]");
                            }
                        }
                    }
                    return false;
                });
                LOG.info("Send request to metadata service:[" + mdRemoteServiceName + "] for building a connection");
                Sender sender = Sender.getSender((String)mdRemoteServiceName);
                try {
                    Object object = sender.ask((Object)new MetadataConnect(dataSourceType, operator, connectParams, ""));
                    if (object instanceof MetadataResponse) {
                        MetadataResponse response = (MetadataResponse)object;
                        if (!response.status()) {
                            throw new WarnException(((Integer)ServiceErrorCode.REMOTE_METADATA_SERVICE_ERROR.getValue()).intValue(), "Connection Failed[\u8fde\u63a5\u5931\u8d25], Msg[" + response.data() + "]");
                        }
                        break block9;
                    }
                    throw new WarnException(((Integer)ServiceErrorCode.REMOTE_METADATA_SERVICE_ERROR.getValue()).intValue(), "Remote Service Error[\u8fdc\u7aef\u670d\u52a1\u51fa\u9519, \u8054\u7cfb\u8fd0\u7ef4\u5904\u7406]");
                }
                catch (Exception t) {
                    if (!(t instanceof WarnException)) {
                        throw new WarnException(((Integer)ServiceErrorCode.REMOTE_METADATA_SERVICE_ERROR.getValue()).intValue(), "Remote Service Error[\u8fdc\u7aef\u670d\u52a1\u51fa\u9519, \u8054\u7cfb\u8fd0\u7ef4\u5904\u7406], message:[" + t.getMessage() + "]");
                    }
                    throw t;
                }
            }
            finally {
                if (!uploadedResources.isEmpty()) {
                    uploadedResources.forEach(resourceId -> {
                        try {
                            this.bmlAppService.clientRemoveResource(operator, (String)resourceId);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            }
        }
    }
}

