/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidateException;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidateStrategy;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidator;
import org.apache.linkis.datasourcemanager.core.validate.strategy.RegExpParameterValidateStrategy;
import org.apache.linkis.datasourcemanager.core.validate.strategy.TypeParameterValidateStrategy;
import org.springframework.stereotype.Component;

@Component
public class DataSourceParameterValidator
implements ParameterValidator {
    private List<ParameterValidateStrategy> strategies = new ArrayList<ParameterValidateStrategy>();

    @PostConstruct
    public void initToRegister() {
        this.registerStrategy(new TypeParameterValidateStrategy());
        this.registerStrategy(new RegExpParameterValidateStrategy());
    }

    @Override
    public void registerStrategy(ParameterValidateStrategy strategy) {
        this.strategies.add(strategy);
    }

    @Override
    public void validate(List<DataSourceParamKeyDefinition> paramKeyDefinitions, Map<String, Object> parameters) throws ParameterValidateException {
        Map<DataSourceParamKeyDefinition, Object> defToValue = paramKeyDefinitions.stream().filter(def -> Objects.nonNull(parameters.get(def.getKey()))).collect(Collectors.toMap(def -> def, def -> {
            Object keyValue = parameters.get(def.getKey());
            parameters.put(def.getKey(), keyValue);
            return keyValue;
        }));
        for (DataSourceParamKeyDefinition def2 : paramKeyDefinitions) {
            boolean needValidate = false;
            if (Objects.nonNull(def2.getRefId())) {
                DataSourceParamKeyDefinition refDef = new DataSourceParamKeyDefinition();
                refDef.setId(def2.getRefId());
                Object refValue = defToValue.get(refDef);
                if (Objects.nonNull(refValue) && Objects.equals(refValue, def2.getRefValue())) {
                    needValidate = true;
                }
            } else {
                needValidate = true;
            }
            if (!needValidate) continue;
            String keyName = def2.getKey();
            Object keyValue = parameters.get(def2.getKey());
            DataSourceParamKeyDefinition.ValueType valueType = def2.getValueType();
            if (null == keyValue) {
                String defaultValue = def2.getDefaultValue();
                if (StringUtils.isNotBlank((String)defaultValue) && valueType == DataSourceParamKeyDefinition.ValueType.SELECT) {
                    defaultValue = defaultValue.split(",")[0].trim();
                }
                keyValue = defaultValue;
            }
            if (null == keyValue || StringUtils.isBlank((String)String.valueOf(keyValue))) {
                if (!def2.isRequire()) continue;
                throw new ParameterValidateException("Param Validate Failed[\u53c2\u6570\u6821\u9a8c\u51fa\u9519], [the value of key: '" + keyName + " cannot be blank']");
            }
            for (ParameterValidateStrategy validateStrategy : this.strategies) {
                if (!validateStrategy.accept(def2.getValueType())) continue;
                validateStrategy.validate(def2, keyValue);
            }
        }
    }

    @Override
    public List<ParameterValidateStrategy> getStrategies() {
        return this.strategies;
    }
}

